<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->model('campaign_model');
		$this->load->model('user_model');
		$this->load->helper('cookie');

		$slur = $this->uri->segment(2);
		if ($slur != "login" && $slur != "verify") {
			if (!$this->input->cookie('adminlog', TRUE)) {
				redirect('/admin/login', 'refresh');
			}			
		}				
	
	}
	public function index()
	{
		// if ($this->input->cookie('adminlog')) {
			$data['campaign'] = $this->campaign_model->get_campaign();
			$this->load->view('view_dashboard', $data);
		// } else {
		// 	redirect('admin/login');
		// }
	}

	public function new_capaign(){
		$this->load->view('view_new');
	}

	public function edit(){

		$data['campaign_one'] = $this->campaign_model->get_campaign_one($this->uri->segment(3));
		
		if($data['campaign_one'])	{
			$this->load->view('view_edit', $data);	
		}	else {
			redirect('admin');	
		}
		
	}

	public function stats(){
		$data_ca['get_campaign_one'] = $this->campaign_model->get_campaign_one($this->uri->segment(3));
		$data_ca['get_coupons_unused'] = $this->campaign_model->get_coupons_unused($this->uri->segment(3));
		$data_ca['get_coupons_used'] = $this->campaign_model->get_coupons_used($this->uri->segment(3));
		if($data_ca['get_campaign_one']){
			$this->load->view('view_stats', $data_ca);
		}else{
			redirect('admin');	
		}			
		
	}
	public function removecampaign(){

		$this->campaign_model->delete_campaign($this->uri->segment(3));
		redirect('admin');	
	}

	public function show_coupon(){
		$data_o['get_coupon_one'] = $this->campaign_model->get_coupons_one($this->uri->segment(3));
		$data_ca['get_campaign_one'] = $this->campaign_model->get_campaign_one($this->uri->segment(3));
		date_default_timezone_set("America/New_York");

		if($data_o['get_coupon_one']){
			$ip = '';	
	     	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {   //check ip from share internet
	            $ip = $_SERVER['HTTP_CLIENT_IP'];
	        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {   //to check ip is pass from proxy
	            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	        } else {
	            $ip = $_SERVER['REMOTE_ADDR'];
	        }
	        $data_c['ip_use'] = $ip;			
			$data_c['time_visit'] = date("y:m:d:h:i:sa");
			$data_c['used'] = 'yes';			
			$slug_coupons =  $data_o['get_coupon_one']->slug_coupons;
			$coupons =  $data_o['get_coupon_one']->c_coupons;
			$css = $data_ca['get_campaign_one']->c_css;
			$c_dailylimit = $data_ca['get_campaign_one']->c_dailylimit;
			$real_whattodo = $data_ca['get_campaign_one']->real_whattodo;
			$c_startdate = $data_ca['get_campaign_one']->c_startdate;
			$c_enddate = $data_ca['get_campaign_one']->c_enddate;
			$c_coupons = '';
			$c_coupons_used = '';
			$count = 0;
			$check_ip_used = '';
		
			$unused = $this->campaign_model->get_coupons_unused($this->uri->segment(3));
			$used   = $this->campaign_model->get_coupons_used($this->uri->segment(3));
			if($used){
				foreach ($used as $key => $value) {				
					if( strtotime(date("Y-m-d 0:0:0"))   < strtotime($value->time_visit) && 
						strtotime(date("Y-m-d 23:59:0")) > strtotime($value->time_visit)){
						if( $value->ip_use == $ip) {
							$check_ip_used = 'used';
						}
						$count +=1;					
					}
				}	
			}

			if(strtotime($c_startdate) < strtotime(date("Y-m-d h:i:sa")) && 
				strtotime($c_enddate)  > strtotime(date("Y-m-d h:i:sa")) )	{

				if($check_ip_used == 'used') {
					$data['coupon'] = $this->campaign_model->get_coupons_used_ip($this->uri->segment(3), $ip);				
						echo '<center><input type="text" onClick="this.select();" id="code" value="'. $data['coupon'][0]->c_coupons .'"></center>';
						echo '<style>'. $css .'</style>';				
				} else {
					if($count <= $c_dailylimit){
						$this->campaign_model->update_coupons_one($coupons,$data_c);
						if($unused){
							foreach ($unused as $key => $value) {
								$c_coupons .= $value->c_coupons ;		
							}
						}
						if($used){
							foreach ($used as $key => $value) {
								$c_coupons_used .= $value->c_coupons ;		
							}	
						} else {
							$c_coupons_used .= $coupons ;	
						}					
						$data['c_coupons'] =  $c_coupons;
						$data['used_coupons'] =  $c_coupons_used;

						$this->campaign_model->update_campaign($this->uri->segment(3),$data);

						echo '<center><input type="text" onClick="this.select();" id="code" value="'.$coupons .'"></center>';
						echo '<style>'. $css .'</style>';
					} else {
						if($real_whattodo == '2'){
							echo '<center><span id="sorry">'. $data_ca['get_campaign_one']->c_displaytext .'</span></center>';
							echo '<style>'. $css .'</style>';
						}else{
							redirect($data_ca['get_campaign_one']->c_redirect);
						}
					}
				}
			} else {
				if($real_whattodo == '2'){
					echo '<center><span id="sorry">'. $data_ca['get_campaign_one']->c_displaytext .'</span></center>';
					echo '<style>'. $css .'</style>';
				}else{
					redirect($data_ca['get_campaign_one']->c_redirect);
				}				
			}
		}
	}

	public function update_campaign(){
		$data_c['c_name'] 	 	 = $this->input->post('newc_name');		 
		$data_c['c_coupons'] 	 = $this->input->post('newc_coupons');		 
		$data_c['c_domain'] 	 = $this->input->post('newc_domain');		 
		$data_c['c_dailylimit']  = $this->input->post('newc_dailylimit');
		$data_c['c_startdate'] 	 = $this->input->post('newc_startdate');
		$data_c['c_enddate'] 	 = $this->input->post('newc_enddate');
		$data_c['real_whattodo'] = $this->input->post('real_whattodo');
		$data_c['c_redirect'] 	 = $this->input->post('newc_redirect');
		$data_c['c_displaytext'] = $this->input->post('newc_displaytext');
		$data_c['c_css'] 		 = $this->input->post('newc_css');
		$this->campaign_model->update_campaign($this->input->post('c_slug'),$data_c);
		$this->campaign_model->delete_coupon($this->input->post('c_slug'));

		$data['slug_coupons'] = $this->input->post('c_slug');
		$array = explode(PHP_EOL, $this->input->post('newc_coupons'));
		
		foreach ($array as $key => $value) {
			$data['c_coupons'] = $value;
			$this->campaign_model->create_coupon($data);
		}

		redirect('admin');	

	}

	public function create_new(){
		$str = '';
		$chars = "abcdefghijklmnopqrstuvwxyz0123456789";
		$size = strlen( $chars );
		for( $i = 0; $i < 16; $i++ ) {
			$str .= $chars[ rand( 0, $size - 1 ) ];
		}	
			
		$data_c['c_slug'] 	 	 = 'c' . $str;		 
		$data_c['c_name'] 	 	 = $this->input->post('newc_name');		 
		$data_c['c_coupons'] 	 = $this->input->post('newc_coupons');		 
		$data_c['c_domain'] 	 = $this->input->post('newc_domain');		 
		$data_c['c_dailylimit']  = $this->input->post('newc_dailylimit');
		$data_c['c_startdate'] 	 = $this->input->post('newc_startdate');
		$data_c['c_enddate'] 	 = $this->input->post('newc_enddate');
		$data_c['real_whattodo'] = $this->input->post('real_whattodo');
		$data_c['c_redirect'] 	 = $this->input->post('newc_redirect');
		$data_c['c_displaytext'] = $this->input->post('newc_displaytext');
		$data_c['c_css'] 		 = $this->input->post('newc_css');
		$this->campaign_model->create_campaign($data_c);

		$data['slug_coupons'] = 'c' . $str;
		$array = explode(PHP_EOL, $this->input->post('newc_coupons'));
		
		foreach ($array as $key => $value) {
			$data['c_coupons'] = $value;
			$this->campaign_model->create_coupon($data);
		}
		redirect('admin');	

	}


	public function logout()
	{
		delete_cookie("adminlog");
		redirect('/');
	}
	public function login()
	{
		if (!$this->input->cookie('adminlog')) {
			$this->load->view('view_login');
		} else {
			redirect('admin');		
		}
	}
	public function reset(){
		$this->load->view('view_reset');
	}
	public function reset_pass(){		
		$this->user_model->save_password($this->input->post('newpass'));
		redirect('admin');	
	}
	public function verify()
	{
		$this->load->model('user_model');
		if ($this->input->post('email') === FALSE || $this->input->post('pass') === FALSE) {
			redirect('admin/login');		
		} else {
			$user = $this->user_model->find_user($this->input->post('email'), $this->input->post('pass'));
			if ($user) {
				$cookie = array(
					'name'   => 'adminlog',
					'value'  => $user->id,
				);
				if ($this->input->post('rememberme') && $this->input->post('rememberme') == "forever") {
				} else {
					$cookie['expire'] = '0';
				}
				$this->input->set_cookie($cookie);
				redirect('admin');					
			} else {
				redirect('admin/login/false');					
			}
		}
	}

}
