<?php
global $WPhtc, $WPhtcEcho;
$debug              = false;
$WPhtc->plugin_path = $plugin_path = WP_CONTENT_DIR . '/plugins/' . plugin_basename( dirname( __FILE__ ) );
$WPhtc->plugin_url  = $plugin_url = WP_CONTENT_URL . '/plugins/' . plugin_basename( dirname( __FILE__ ) );

//$q=explode('&',$_SERVER['QUERY_STRING']);
//$purl='http'.((!empty($_SERVER['HTTPS'])) ? 's' : '').'://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].'?'.$q[0];

$q    = explode( "&", $_SERVER['REQUEST_URI'] );
$purl = $q[0];
$WPhtc->page_action();

function WPHTCui( $namesArray ) {
	$plugin_path = WP_CONTENT_DIR . '/plugins/' . plugin_basename( dirname( __FILE__ ) );
	if ( ! is_array( $namesArray ) ) {
		$namesArray = array( $namesArray );
	}
	foreach ( $namesArray as $name ) {
		include( $plugin_path . '/admin-ui-includes/' . $name . '.php' );
	}
}

?>

<div id="wphtc-page" class="wrap">
	<h2>WP htaccess Control</h2>
	<?php
	if ( ! current_user_can( "administrator" ) ) {
		echo '<p>' . __( 'Please log in as admin', 'wp-htaccess-control' ) . '</p>';

		return;
	}
	?>

	<?php WPHTCui( 'sidebar' ) ?>

	<div id="wphtc-main">
		<form method="post" action="<?php echo $purl ?>">
			<?php if ( $WPhtcEcho != '' ) { ?>
				<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">
					<p><?php echo $WPhtcEcho; ?></p>
				</div>
				<?php
			}
			# Donation Message
			if ( $WPhtc->get_data( 'donation_hidden_time' ) && $WPhtc->get_data( 'donation_hidden_time' ) < time() ) {
				?>
				<div class="updated">
					<p>
						<strong>Is this plugin useful? Consider making a donation encouraging me to continue supporting
							it!</strong>
						<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=antonio%40antonioandra%2ede&lc=US&item_name=WP%20htaccess%20Control%20%28Antonio%20Andrade%29&no_note=0&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHostedGuest">
							<img alt="Donate" border="0"
							     src="https://www.paypalobjects.com/webstatic/en_US/btn/btn_donate_74x21.png">
						</a>
						<span><a href="<?php echo $purl ?>&action=hide_donation_message">Hide this message</a></span>
					</p>
				</div>
			<?php } ?>
			<?php WPHTCui( array(
				'custom-author-permalink',
				'custom-pagination-permalink',
				'custom-search-permalink',
				'remove-bases',
				'advanced-archives',
				'more-rewrite',
				'custom-htaccess',
				'replace-htaccess',
				'htaccess-suggestions',
				'maintenance-mode'
			) ) ?>

			<?php wp_nonce_field( 'WPhtc_settings' ); ?>
			<input type="hidden" name="action" value="update"/>

			<div class="wphtc-menu">
				<a class="button-secondary"
				   href="<?php echo wp_nonce_url( $purl . "&action=reset_rules", 'WPhtc_reset_settings' ); ?>"><?php _e( 'Reset all rules', 'wp-htaccess-control' ); ?></a>
				<input type="submit" class="button-primary"
				       value="<?php _e( 'Save all changes', 'wp-htaccess-control' ); ?>"/>
			</div>
		</form>
		<div class="wphtc-section">
			<div class="wphtc-section-title stuffbox">
				<div title="Click to toggle" class="handlediv"
				     style="background:url('<?php bloginfo( "wpurl" ) ?>/wp-admin/images/menu-bits.gif') no-repeat scroll left -111px transparent">
					<br></div>
				<h3><?php _e( 'Current htaccess file as it is generated by WordPress', 'wp-htaccess-control' ); ?></h3>
			</div>
			<div class="wphtc-inputs start-open">
				<p>
					<code><?php echo str_replace( array(
							"&lt;br /&gt;",
							"&lt;br/&gt;"
						), "<br/>", htmlspecialchars( $WPhtc->get_data( 'cur_hta' ) ) ); ?></code>
				</p>
			</div>
		</div>

		<!-- INSTRUCTIONS -->
		<div class="wphtc-section permanently-open">
			<div class="wphtc-section-title stuffbox">
				<h3><?php _e( 'Read Me', 'wp-table-of-paginated-contents' ); ?></h3>
			</div>
			<table class="form-table wphtc-inputs start-open">
				<tr valign="top">
					<th scope="row" style="width:18%;"></th>
					<td>
						<p class="description"><?php _e( 'This plugin has made such a long way that it should really now be called <strong>WP htaccess and Rewrite Control</strong>.', 'wp-htaccess-control' ); ?></p>

						<p class="description"><?php _e( 'Some of the features it provides might not work as expect on all environments and setups. You are advised to test configurations on a separate staging, on the same server and with the same theme and plugins. Please report any issues you might face.', 'wp-htaccess-control' ); ?></p>

						<p class="description"><?php _e( 'If your setup seems to get out of control there are a few options to reverse all changes:', 'wp-htaccess-control' ); ?></p>
						<ul class="description">
							<li>
								1) <?php _e( 'Click on "Reset all rules", at the bottom of this page;', 'wp-htaccess-control' ); ?></li>
							<li>
								2) <?php _e( 'rename/delete the plugin folder and re-submit your permalink settings under "Settings > Permalinks"', 'wp-htaccess-control' ); ?> </li>
							<li>
								3) <?php _e( 'if the previous did not solve your issue, remove the .htaccess file on your blog\'s root directory and repeat step 2;', 'wp-htaccess-control' ); ?></li>
							<li>
								4) <?php _e( 'in such cases you might want to get back back to the last version you knew working, which you\'ll find at', 'wp-htaccess-control' ); ?>
								<a href="http://wordpress.org/extend/plugins/wp-htaccess-control/download/">http://wordpress.org/extend/plugins/wp-htaccess-control/download/</a>.
							</li>
						</ul>
						<p><?php _e( 'Version 3.3 was tested up to WordPress 3.5.1.', 'wp-htaccess-control' ); ?></p>

						<p><?php _e( 'Version 3.4 was tested on WordPress 3.9.', 'wp-htaccess-control' ); ?></p>
					</td>
				</tr>
			</table>
		</div>

		<?php if ( $debug ) { ?>
			<div class="wphtc-section start-open">
				<div class="wphtc-section-title stuffbox">
					<div title="Click to toggle" class="handlediv"
					     style="background:url('<?php bloginfo( "wpurl" ) ?>/wp-admin/images/menu-bits.gif') no-repeat scroll left -111px transparent">
						<br></div>
					<h3><?php _e( 'Debug Data', 'wp-htaccess-control' ); ?></h3>
				</div>
				<div class="wphtc-inputs">
                    <pre>
                        <?php print_r( $WPhtc->data ); ?>
                    </pre>

                    <pre>
                        <?php global $wp_rewrite;
                        print_r( $wp_rewrite ); ?>
                    </pre>
				</div>
			</div>
		<?php } ?>
	</div>
</div>
