/*
 * Decompiled with CFR 0.152.
 */
package JUpload.gui;

import JUpload.Messages;
import JUpload.ProgressInformationObject;
import JUpload.ProgressListener;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class UploadStatus
extends JPanel {
    private JLabel messagebar = new JLabel();
    private JLabel filenamebar = new JLabel();
    private JProgressBar progressbar = new JProgressBar();
    private JProgressBar totalprogressbar = new JProgressBar();
    private JProgressBar jobsbar = new JProgressBar();
    private ProgressInformationObject pio = new ProgressInformationObject();
    private static UploadStatus instance;
    private Vector listener;
    private boolean running;

    private UploadStatus() {
        BoxLayout bl = new BoxLayout(this, 1);
        this.setLayout(bl);
        this.messagebar.setAlignmentX(0.0f);
        this.add(this.messagebar);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.jobsbar.setAlignmentX(0.0f);
        this.add(this.jobsbar);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.totalprogressbar.setAlignmentX(0.0f);
        this.add(this.totalprogressbar);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.progressbar.setAlignmentX(0.0f);
        this.add(this.progressbar);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.filenamebar.setAlignmentX(0.0f);
        this.add(this.filenamebar);
        this.add(Box.createHorizontalGlue());
        this.validate();
    }

    public void doResize() {
        int width = this.getWidth();
        this.jobsbar.setPreferredSize(new Dimension(width, this.jobsbar.getHeight()));
        this.progressbar.setPreferredSize(new Dimension(width, this.progressbar.getHeight()));
        this.filenamebar.setPreferredSize(new Dimension(width, this.filenamebar.getHeight()));
        this.jobsbar.setSize(new Dimension(width, this.jobsbar.getHeight()));
        this.progressbar.setSize(new Dimension(width, this.progressbar.getHeight()));
        this.filenamebar.setSize(new Dimension(width, this.filenamebar.getHeight()));
        this.progressbar.setForeground(Color.red);
        if (Configurator.getForegroundColor() != null) {
            this.jobsbar.setForeground(Configurator.getForegroundColor());
            this.progressbar.setForeground(Configurator.getForegroundColor());
            this.totalprogressbar.setForeground(Configurator.getForegroundColor());
        }
    }

    public void setMessage(String msg) {
        this.pio.setMessage(msg);
        this.messagebar.setText(msg);
        this.notifyProgressMeterListener();
        this.revalidate();
    }

    public void start() {
        this.running = true;
        this.pio.setStartTime();
        this.notifyProgressMeterListenerStart();
    }

    public void stop() {
        this.running = false;
        this.notifyProgressMeterListenerStop();
        this.setTotalProgressbarVisible(false);
        this.setJobProgressbarVisible(false);
        this.setProgressbarVisible(false);
        this.setValue(0L, 0L);
        this.setJobsValue(0L, 0L);
        this.setTotalValue(0L, 0L);
        this.setMessage("");
    }

    private void notifyProgressMeterListenerStart() {
        JUpload jupload = JUpload.getInstance();
        Vector listener1 = jupload.getProgressMeterListener();
        Iterator iter = listener1.iterator();
        while (iter.hasNext()) {
            ProgressListener lst = (ProgressListener)iter.next();
            lst.startProgress();
        }
    }

    private void notifyProgressMeterListenerStop() {
        JUpload jupload = JUpload.getInstance();
        Vector listener1 = jupload.getProgressMeterListener();
        Iterator iter = listener1.iterator();
        while (iter.hasNext()) {
            ProgressListener lst = (ProgressListener)iter.next();
            lst.stopProgress();
        }
    }

    private void notifyProgressMeterListener() {
        JUpload jupload = JUpload.getInstance();
        this.listener = jupload.getProgressMeterListener();
        Iterator iter = this.listener.iterator();
        while (iter.hasNext()) {
            ProgressListener lst = (ProgressListener)iter.next();
            lst.valueChanged(this.pio);
        }
    }

    public void setFilename(String filename) {
        this.pio.setFilename(filename);
        this.filenamebar.setText(filename);
        this.notifyProgressMeterListener();
        this.revalidate();
    }

    public void setValue(long i, long max) {
        this.pio.setCurrentFileValue(i);
        this.pio.setMaxFileValue(max);
        double prozent = (double)i / (double)max * 100.0;
        int iMax = 0;
        int iValue = 0;
        if (max > Integer.MAX_VALUE || i > Integer.MAX_VALUE) {
            iMax = 100;
            iValue = (int)prozent;
        } else {
            iMax = (int)max;
            iValue = (int)i;
        }
        this.progressbar.setMaximum(iMax);
        this.progressbar.setStringPainted(true);
        this.progressbar.setValue(iValue);
        String strProzent = Math.round(prozent) + Messages.getString("UploadStatus.0");
        this.pio.setFilePercentage(strProzent);
        long duration = (System.currentTimeMillis() - this.pio.getStartTime()) / 1000L;
        this.pio.setFileDuration(duration);
        if (duration > 0L) {
            String strETA;
            long speed = i / duration;
            this.pio.setFileSpeed(speed /= 1024L);
            String strSpeed = speed + Messages.getString("UploadStatus.1");
            long lETA = Math.round(100.0 / prozent * (double)duration) - duration;
            if (lETA > 60L) {
                lETA = Math.round(lETA / 60L);
                strETA = lETA + Messages.getString("UploadStatus.2");
            } else {
                strETA = lETA + Messages.getString("UploadStatus.3");
            }
            this.progressbar.setString(Messages.getString("UploadStatus.4") + strProzent + Messages.getString("UploadStatus.5") + strSpeed + Messages.getString("UploadStatus.6") + strETA);
        } else {
            this.progressbar.setString(strProzent);
        }
        this.notifyProgressMeterListener();
    }

    public void close() {
        this.setVisible(false);
    }

    public void setTotalValue(long i, long max) {
        this.pio.setCurrentTotalValue(i);
        this.pio.setMaxTotalValue(max);
        this.totalprogressbar.setMaximum((int)max);
        this.totalprogressbar.setStringPainted(true);
        this.totalprogressbar.setValue((int)i);
        double prozent = (double)i / (double)max * 100.0;
        String strProzent = Math.round(prozent) + Messages.getString("UploadStatus.11");
        this.pio.setTotalPercentage(strProzent);
        this.pio.setTotalPercentageAsInt(Math.round(prozent));
        long duration = (System.currentTimeMillis() - this.pio.getStartTime()) / 1000L;
        this.pio.setTotalDuration(duration);
        if (duration > 0L) {
            String strETA;
            long speed = i / duration;
            this.pio.setTotalSpeed(speed /= 1024L);
            String strSpeed = speed + Messages.getString("UploadStatus.12");
            long lETA = Math.round(100.0 / prozent * (double)duration) - duration;
            if (lETA > 60L) {
                lETA = Math.round(lETA / 60L);
                strETA = lETA + Messages.getString("UploadStatus.13");
            } else {
                strETA = lETA + Messages.getString("UploadStatus.14");
            }
            this.totalprogressbar.setString(Messages.getString("UploadStatus.15") + strProzent + Messages.getString("UploadStatus.16") + strSpeed + Messages.getString("UploadStatus.17") + strETA);
        } else {
            this.totalprogressbar.setString(strProzent);
        }
        this.validate();
        this.notifyProgressMeterListener();
    }

    public void setTotalProgressbarVisible(boolean b) {
        this.totalprogressbar.setVisible(b);
    }

    public ProgressInformationObject getProgressInformationObject() {
        return this.pio;
    }

    public static UploadStatus getInstance() {
        if (instance == null) {
            instance = new UploadStatus();
        }
        return instance;
    }

    public void setJobsValue(long i, long max) {
        this.pio.setCurrentJobValue(i);
        this.pio.setMaxJobValue(max);
        this.jobsbar.setMaximum((int)max);
        this.jobsbar.setStringPainted(true);
        this.jobsbar.setValue((int)i);
        double prozent = (double)i / (double)max * 100.0;
        String strProzent = Math.round(prozent) + Messages.getString("UploadStatus.11");
        this.pio.setJobPercentage(strProzent);
        this.pio.setJobPercentageAsInt(Math.round(prozent));
        long duration = (System.currentTimeMillis() - this.pio.getStartTime()) / 1000L;
        this.pio.setJobDuration(duration);
        if (duration > 0L) {
            String strETA;
            long speed = i / duration;
            this.pio.setJobSpeed(speed /= 1024L);
            long lETA = Math.round(100.0 / prozent * (double)duration) - duration;
            if (lETA > 60L) {
                lETA = Math.round(lETA / 60L);
                strETA = lETA + Messages.getString("UploadStatus.13");
            } else {
                strETA = lETA + Messages.getString("UploadStatus.14");
            }
            this.jobsbar.setString(Messages.getString("UploadStatus.18") + strProzent + Messages.getString("UploadStatus.16") + strETA);
        } else {
            this.jobsbar.setString(strProzent);
        }
        this.validate();
        this.notifyProgressMeterListener();
    }

    public void setJobProgressbarVisible(boolean b) {
        this.jobsbar.setVisible(b);
    }

    public void setProgressbarVisible(boolean b) {
        this.progressbar.setVisible(b);
    }

    public boolean isRunning() {
        return this.running;
    }
}

