/*
 * Decompiled with CFR 0.152.
 */
package JUpload.plugin.builtin;

import JUpload.plugin.builtin.JUploadContext;
import JUpload.plugin.builtin.JUploadPlugin;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;

public class DragNDropPlugin
extends JUploadPlugin {
    private static final Logger logger = Logger.getLogger((class$JUpload$plugin$builtin$DragNDropPlugin == null ? (class$JUpload$plugin$builtin$DragNDropPlugin = DragNDropPlugin.class$("JUpload.plugin.builtin.DragNDropPlugin")) : class$JUpload$plugin$builtin$DragNDropPlugin).getName());
    private Image disabledImage;
    private Image defaultImage;
    private Image hoverImage;
    private Image currentImage;
    static /* synthetic */ Class class$JUpload$plugin$builtin$DragNDropPlugin;

    public String getPluginLabel() {
        return "DragNDrop";
    }

    public String getPluginDescription() {
        return "Drag and Drop Plugin for JUpload";
    }

    public String getPluginVersion() {
        return "1.0.0";
    }

    public String getPluginVendor() {
        return "jupload.biz";
    }

    public void startPlugin(JUploadContext ctx) {
        try {
            this.checkParameters();
            this.initializeBackgroundImages();
            this.initializeDragAndDrop();
            this.repaint();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem initializing", e);
        }
    }

    private void checkParameters() throws Exception {
        if (this.getParameter("disabledImageURL") == null) {
            throw new ConfigurationException("You need to set <PARAM NAME=\"disabledImageURL\" VALUE=\"myimage.jpg\">");
        }
        if (this.getParameter("defaultImageURL") == null) {
            throw new ConfigurationException("You need to set <PARAM NAME=\"defaultImageURL\" VALUE=\"myimage.jpg\">");
        }
        if (this.getParameter("hoverImageURL") == null) {
            throw new ConfigurationException("You need to set <PARAM NAME=\"hoverImageURL\" VALUE=\"myimage.jpg\">");
        }
    }

    public void stopPlugin(JUploadContext ctx) {
    }

    private void initializeBackgroundImages() throws Exception {
        URL disabledURL = new URL(this.getCodeBase(), this.getParameter("disabledImageURL"));
        this.disabledImage = this.getAppletContext().getImage(disabledURL);
        if (this.disabledImage == null) {
            throw new ConfigurationException("Could not load " + disabledURL);
        }
        URL defaultURL = new URL(this.getCodeBase(), this.getParameter("defaultImageURL"));
        this.defaultImage = this.getAppletContext().getImage(defaultURL);
        if (this.defaultImage == null) {
            throw new ConfigurationException("Could not load " + defaultURL);
        }
        URL hoverURL = new URL(this.getCodeBase(), this.getParameter("hoverImageURL"));
        this.hoverImage = this.getAppletContext().getImage(hoverURL);
        if (this.hoverImage == null) {
            throw new ConfigurationException("Could not load " + hoverURL);
        }
        this.currentImage = this.defaultImage;
        this.repaint();
    }

    public void initializeDragAndDrop() {
        DropTarget dt = new DropTarget();
        dt.setComponent(this);
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new DropTargetAdapter(){

                public void dragEnter(DropTargetDragEvent dtde) {
                    super.dragEnter(dtde);
                    logger.info("enter");
                    DragNDropPlugin.this.currentImage = DragNDropPlugin.this.hoverImage;
                    DragNDropPlugin.this.repaint();
                }

                public void dragExit(DropTargetEvent dte) {
                    super.dragExit(dte);
                    logger.info("exit");
                    DragNDropPlugin.this.currentImage = DragNDropPlugin.this.defaultImage;
                    DragNDropPlugin.this.repaint();
                }

                public void drop(DropTargetDropEvent dtde) {
                    logger.info("drop");
                    DragNDropPlugin.this.currentImage = DragNDropPlugin.this.disabledImage;
                    DragNDropPlugin.this.repaint();
                    Transferable t = dtde.getTransferable();
                    DataFlavor[] df = t.getTransferDataFlavors();
                    dtde.acceptDrop(dtde.getDropAction());
                    ArrayList<File> list = new ArrayList<File>();
                    for (int i = 0; i < df.length; ++i) {
                        try {
                            Object droppedObject = t.getTransferData(df[i]);
                            if (!(droppedObject instanceof List)) continue;
                            List data = (List)droppedObject;
                            Iterator iter = data.iterator();
                            while (iter.hasNext()) {
                                File filename = (File)iter.next();
                                list.add(filename);
                            }
                            continue;
                        }
                        catch (UnsupportedFlavorException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    logger.info("Got files:" + list);
                    DragNDropPlugin.this.getJUpload().walkFileTree(list);
                    DragNDropPlugin.this.currentImage = DragNDropPlugin.this.defaultImage;
                    DragNDropPlugin.this.repaint();
                }
            });
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        if (this.currentImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            g2d.drawImage(this.currentImage, 0, 0, width, height, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

