/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.swingVersion.IQueueListener;
import JUpload.swingVersion.IQueueView;
import JUpload.utilities.MyFile;
import JUpload.utilities.QueueSelectedFiles;
import java.awt.Component;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JFileTable
extends JTable
implements IQueueView,
IQueueListener {
    private final QueueSelectedFiles queueSelectedFiles;
    private TableModel fDataModel;
    TableColumnModel cm;

    public JFileTable(QueueSelectedFiles queueSelectedFiles) {
        this.queueSelectedFiles = queueSelectedFiles;
        queueSelectedFiles.addQueueListener(this);
        this.cm = this.createColumnModel();
        JTableHeader newTableHeader = new JTableHeader(this.cm);
        this.setTableHeader(newTableHeader);
        this.fDataModel = new DefaultTableModel();
        this.setModel(this.fDataModel);
    }

    private TableColumnModel createColumnModel() {
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn colName = new TableColumn();
        colName.setHeaderValue("Name");
        cm.addColumn(colName);
        colName = new TableColumn();
        colName.setHeaderValue("Size");
        cm.addColumn(colName);
        colName = new TableColumn();
        colName.setHeaderValue("Type");
        cm.addColumn(colName);
        colName = new TableColumn();
        colName.setHeaderValue("Modified");
        cm.addColumn(colName);
        return cm;
    }

    public Component getComponent() {
        return this;
    }

    public void removeAll() {
        this.fDataModel = new DefaultTableModel();
        this.invalidate();
    }

    public Object[] getSelected() {
        return null;
    }

    public void removeSelected() {
    }

    public void update() {
        this.invalidate();
    }

    public void setSelected(Object object) {
    }

    public void queueChanged(DefaultListModel listModel) {
        DefaultListModel listModel2 = this.queueSelectedFiles.getListModel();
        this.fDataModel = new DefaultTableModel(listModel2.getSize(), this.cm.getColumnCount());
        for (int i = 0; i < listModel2.getSize(); ++i) {
            MyFile file = (MyFile)listModel2.get(i);
            this.fDataModel.setValueAt(file.getName(), i, 0);
            this.fDataModel.setValueAt(new Long(file.length()), i, 1);
            this.fDataModel.setValueAt("---", i, 2);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(file.lastModified());
            this.fDataModel.setValueAt(cal.getTime(), i, 3);
        }
        this.setModel(this.fDataModel);
        this.invalidate();
    }

    public void queueChanging(DefaultListModel listModel) {
    }
}

