/*
 * Decompiled with CFR 0.152.
 */
import JUpload.Messages;
import JUpload.swingVersion.IFileSelectionListener;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;

public class JUploadPlugin_ImagePreview
extends JApplet
implements Runnable,
IFileSelectionListener {
    private MyFile file;
    private BufferedImage image;
    private Image rawImage;
    private boolean isInUse;
    private boolean hasToLoad;
    private JUpload jupload;
    private boolean juploadLoaded = false;

    public void init() {
        super.init();
        JUpload.waitForLoad(this);
        this.isInUse = true;
        this.hasToLoad = false;
        new Thread(this).start();
    }

    public void stop() {
        super.stop();
        this.isInUse = false;
    }

    public void displayPreview(MyFile newFile) {
        if (newFile == this.file) {
            return;
        }
        this.file = newFile;
        this.hasToLoad = true;
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (this.isInUse) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.juploadLoaded) {
                this.jupload = JUpload.getInstance();
                if (this.jupload != null && this.jupload.isReady()) {
                    this.jupload.addFileSelectionListener(this);
                    this.juploadLoaded = true;
                }
            }
            if (!this.hasToLoad) continue;
            Debug.println(this, "hasToLoad");
            this.hasToLoad = false;
            this.loadImage();
        }
    }

    private void loadImage() {
        int imageHeight;
        int imageWidth;
        double imageRatio;
        int preferredHeight;
        if (this.image != null) {
            Debug.println(this, "ImagePreview() loadImage() Clearing previous image");
            this.image.getGraphics().setColor(Configurator.getBackgroundColor());
            this.image.getGraphics().drawString(Messages.getString("ImagePreview.0"), 10, 10);
            this.image.getGraphics().drawString(this.file.getName(), 10, 30);
            this.repaint();
        }
        Debug.println(this, "Previewing:" + this.file);
        byte[] data = null;
        if (this.file != null) {
            MyFile mFile = this.file;
            if (mFile.isVirtual()) {
                Debug.println(this, "ImagePreview loading virtual data");
                data = mFile.getVirtualData();
                this.rawImage = new ImageIcon(data).getImage();
            } else {
                Debug.println(this, "ImagePreview loading file");
                this.rawImage = new ImageIcon(this.file.getPath()).getImage();
            }
        }
        Insets insets = this.getInsets();
        int preferredWidth = this.getWidth() - insets.left - insets.right;
        double preferredRatio = (double)preferredWidth / (double)(preferredHeight = this.getHeight() - insets.top - insets.bottom);
        if (preferredRatio < (imageRatio = (double)(imageWidth = this.rawImage.getWidth(null)) / (double)(imageHeight = this.rawImage.getHeight(null)))) {
            preferredHeight = (int)((double)preferredWidth / imageRatio);
        } else {
            preferredWidth = (int)((double)preferredHeight * imageRatio);
        }
        Debug.println(this, "ImagePreview() loadImage() Creating thumbnail");
        this.image = new BufferedImage(preferredWidth, preferredHeight, 2);
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(this.rawImage, 0, 0, preferredWidth, preferredHeight, null);
        Debug.println(this, "ImagePreview() loadImage() Repainting");
        this.repaint();
    }

    public void paint(Graphics g) {
        if (Configurator.getBackgroundColor() != null) {
            g.setColor(Configurator.getBackgroundColor());
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, (this.getWidth() - this.image.getWidth()) / 2, (this.getHeight() - this.image.getHeight()) / 2, this.image.getWidth(), this.image.getHeight(), null);
        }
    }

    public void selectionChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            JList jlist = (JList)e.getSource();
            if (jlist.getModel().getSize() == 0) {
                return;
            }
            if (jlist.getSelectedValue() instanceof MyFile) {
                MyFile a_file = (MyFile)jlist.getSelectedValue();
                this.displayPreview(a_file);
            }
        }
    }
}

