<?php
/*
Plugin Name: NMTK Prosperent Ads
Plugin URI: http://nichemarketingtoolkit.com
Description: Displays ads from the Prosperent network.
Author: Peter Coughlin
Version: 2.8.1
Author URI: http://petercoughlin.com

Changelog
---------
2.8.1	Added option to show search and sort on a page by page basis.
2.8		Aded manual search box to listings.
2.7		Added support for extendedQuery and extendedSortMode.
		Added option to display thumbnails.
		Amended caching to only cache transient keys of 45 chars or less.
2.6.2	Added option to display Merchant.
		Added option to open affiliate links in new window.
2.6.1	Added option to nofollow affiliate links.
2.6		Updated to support Prosperent API changes.
2.5		Upgraded layout and CSS code.
		Replaced separate options for image width and height with single image size option.
2.4		Added option to clear the cache.
2.3		Fixed redirect bug with blog in subfolder.
2.2		Added pre v3 backwards compatibility for menus.
2.1		Added cloaked folder functionality.
2.0		Integrated into NMTK Tools.
1.9.1	Fixed bug with caching products.
1.9		Added gallery ad display option.
1.8		Added option to force country.
1.7		Added conditional API login on settings page.
1.6		Integrated MaxMind GeoIP web service.
1.5		Fixed bug for no products found.
1.4		Fixed bug with single pages.
1.3		Added option to show ad elements.
1.2		Added alerts to settings page.
1.1		Added option to show on single posts only.
1.0		Initial version.
*/

// start session if necessary..
if ( '' == session_id() )
	session_start();

class nmtk_prosperent {

	var $name = 'NMTK Prosperent Ads';
	var $shortname = 'Prosperent Ads';
	var $version = '2.8.1';
	var $slug;
	var $url;
	var $dir;
	var $basename;

	function __construct() {

		$this->slug = str_replace( array( basename( __FILE__ ), '/' ), '', plugin_basename( __FILE__ ) );
		$this->url = plugin_dir_url( __FILE__ );
		$this->dir = str_replace( '\\', '/', plugin_dir_path( __FILE__ ) );
		$this->basename = plugin_basename( __FILE__ );

		add_action( 'wp_head', array( &$this, 'wp_head' ) );
		add_action( 'template_redirect', array( &$this, 'template_redirect' ) );
		add_shortcode( 'nmtk-prosperent', array( &$this, 'shortcode' ) );

	}// end func
	
	function activate() {
		// stuff to do when the plugin is activated
	}// end func
	
	function deactivate() {
		// delete_option( 'nmtk_prosperent' );
	}// end func

	function shortcode( $atts ) {

		$options = $this->get_options();

		// if we're only showing on single pages and this isn't one.. bail out now..
		if ( $options['single_only'] && !is_singular() )
			return;

		// get values from plugin settings page..
		$api_key = $options['api_key'];
		$channel_id = stripslashes($options['channel_id']);
		$debug_mode = $options['debug_mode'];
		$use_search_referrer = $options['use_search_referrer'];
		$keyword = stripslashes($options['keyword']);
		$sort_by = $options['sort_by'];
		$show_search = $options['show_search'];
		$show_sortby = $options['show_sortby'];
		$template = $options['template'];
		$show_title = $options['show_title'];
		$show_image = $options['show_image'];
		$show_description = $options['show_description'];
		$show_price = $options['show_price'];
		$show_sale_price = $options['show_sale_price'];
		$show_details_link = $options['show_details_link'];
		$show_buy_link = $options['show_buy_link'];
		$show_merchant = $options['show_merchant'];
		$max_ads = $options['max_ads'];
		$max_image_size = $options['max_image_size'];
		$show_thumbnails = $options['show_thumbnails'];
		$custom_template = stripslashes($options['custom_template']);
		$link_cloak_folder = $options['link_cloak_folder'];
		$nofollow_links = $options['nofollow_links'];
		$new_window = $options['new_window'];
		$country = $options['country'];

		// search engine query..
		if ( $use_search_referrer && $_SERVER['HTTP_REFERER'] )
			$search_phrase = $this->get_query_from_referer( $_SERVER['HTTP_REFERER'] );
		if ( isset( $search_phrase ) && false !== $search_phrase )
			$keyword = $search_phrase;
		
		// overwrite with values from shortcode
		extract( shortcode_atts( array(
			'keyword' => $keyword,
			'sort_by' => $sort_by,
			'channel_id' => $channel_id,
			'template' => $template,
			'max_ads' => $max_ads,
			'max_image_size' => $max_image_size,
			'show_search' => $show_search,
			'show_sortby' => $show_sortby
		), $atts ) );

		$show_search = $this->boolval( $show_search );
		$show_sortby = $this->boolval( $show_sortby );

		if ( isset( $_POST['nmtkprosperentsearch'] ) && strlen( $_POST['nmtkprosperentsearch'] ) )
			$keyword = $_POST['nmtkprosperentsearch'];

		// check minimum requirements..
		if ( '' == $api_key )
			return $this->show_error( 'Please provide an API key on the Prosperent plugin settings page.', true );
		if ( '' == $keyword )
			return $this->show_error( 'Please provide a default keyword phrase on the Prosperent plugin settings page.', true );

		// visitor ip..
		if ( isset( $_SESSION['visitor_ip'] ) )
			$visitor_ip = $_SESSION['visitor_ip'];

		// otherwise we need to find one..
		else {
			// if we're forcing the country, let's use that to get an ip..
			if ( 'auto' != $country ) {
				$country_ips = array( 'US' => '3.0.0.0', 'CA' => '24.54.0.0', 'UK' => '2.96.0.0', 'DE' => '53.0.0.0', 'FR' => '62.4.0.0' );
				$visitor_ip = $country_ips[$country];			
			}
			// if not, grab the remote address..
			else
				$visitor_ip = $_SERVER['REMOTE_ADDR'];

			// we should have something by now, but let's check just in case..
			if ( !preg_match( '/^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/', $visitor_ip ) )
				$visitor_ip = '3.0.0.0';

			$_SESSION['visitor_ip'] = $visitor_ip;
		}// end if

		// if we've already got country code..
		if ( isset( $_SESSION['country_code'] ) )
			$country_code = $_SESSION['country_code'];

		// or if we're forcing the country..
		elseif ( 'auto' != $country ) {
			$country_code = $country;
			$_SESSION['country_code'] = $country_code;		
		}// end if

		// check for cache of products..
		if ( '' != $country_code ) {
			//$transient_key = 'nmtk_' . $country_code . '_' . sanitize_file_name( $keyword );
			$transient_key = $this->get_transient_key( $country_code, $keyword, $sort_by );
			if ( false !== $transient_key )
				$products = get_transient( $transient_key );
		}

		// if we didn't find a cache of products..
		if ( false === $products || !is_array( $products ) || !count( $products ) ) {

			// get the products..
			$extendedQuery = urlencode( $keyword );
			$extendedSortMode = urlencode( $sort_by );
			//$url = "http://api.prosperent.com/api/search?api_key=$api_key&query=$query&visitor_ip=$visitor_ip&channel_id=$channel_id&page=$page&limit=$max_ads&debugMode=$debug_mode";
			$url = "http://api.prosperent.com/api/search?api_key=$api_key&visitor_ip=$visitor_ip"
				. "&extendedQuery=$extendedQuery&extendedSortMode=$extendedSortMode"
				. "&channel_id=$channel_id&page=$page&limit=$max_ads&debugMode=$debug_mode";
			
			$response = wp_remote_fopen( $url );

			if ( $response ) {

				if ( false !== strpos( $response, 'errors' ) ) {

					$json = json_decode( $response, $array = true );
					if ( $json['errors'] )
						return $this->show_error( $json['errors'][0]['msg'], $debug_mode );

					else {

						$products = $json['data'];
						if ( is_array( $products ) && count( $products ) ) {

							// cache these products for this country code..
							if ( '' != $json['countryCode'] ) {
								//$transient_key = 'nmtk_' . $json['countryCode'] . '_' . sanitize_file_name( $keyword );
								$transient_key = $this->get_transient_key( $json['countryCode'], $keyword, $sort_by );
								if ( false !== $transient_key )
									set_transient( $transient_key, $products, 86400 );
								$_SESSION['country_code'] = $json['countryCode'];
							}// end if

						}
						else
							return $this->show_error( 'No products found. Query: "' . $keyword . '". IP address: ' . $visitor_ip, $debug_mode );

					}// end if

				}
				else
					return $this->show_error( 'Unable to decode JSON response and retrieve products.', $debug_mode );

			}
			else
				return $this->show_error( 'Unable to connect to Prosperent server.', $debug_mode );

		}// end if

		// products..
		$output .= '<div class="nmtk-prosperent nmtk-prosperent-' . $template . '">';

		// display search & sort by..
		if ( $show_search || $show_sortby ) {

			if ( is_ssl() )
				$protocol = 'https://';
			else
				$protocol = 'http://';
			$action = $protocol . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			$criteria = (int) $_POST['nmtkprosperentsortby'];
			$nmtksearch = htmlentities( stripslashes($_POST['nmtkprosperentsearch']) );
			$output .= '<div class="nmtk-prosperent-sort nmtk-clear"><form method="post" action="'.$action.'">'
				. '<table style="width:100%"><tr>'
				. '<td style="width:1%;text-align:left;">';
				if ( $show_search ) {
					$output .= '<table><tr><td nowrap="nowrap">Refine your search:</td><td><input type="text" name="nmtkprosperentsearch" class="nmtkprosperentsearch" value="'.$nmtksearch.'" /></td><td><input type="submit" value="Go" /></td></tr></table>';
				}// end if
				$output .= '</td><td style="width:98%"> </td><td style="width:1%;text-align:right;">';
				if ( $show_sortby ) {
					$output .= '<table><tr><td nowrap="nowrap">Sort results by:</td><td><select name="nmtkprosperentsortby">'
					. '<option value="0">Relevance</option>'
					. '<option value="1"';if ( 1 == $criteria ) $output .= ' selected="selected"';$output .= '>Price: low to high</option>'
					. '<option value="2"';if ( 2 == $criteria ) $output .= ' selected="selected"';$output .= '>Price: high to low</option>'
					. '</select></td><td><input type="submit" value="OK" /></td></tr></table>';
				}// end if
				$output .= '</td>'
				. '</tr></table>'
				. '</form></div>';
			
			if ( $criteria ) {
				switch( $criteria ) {
					case 1:
						foreach ( $products as $key => $value )
							$index[$key] = $value['price'];
						array_multisort($index, SORT_ASC, $products);
						break;
					case 2:
						foreach ( $products as $key => $value )
							$index[$key] = $value['price'];
						array_multisort($index, SORT_DESC, $products);
						break;
				}// end switch
			}// end if

		}// end if

		// just in case we've changed max ads but still have cache..
		$products = array_splice( $products, 0, $max_ads );

		// loop through products..
		foreach ( $products as $product ) {

			$title = $product['keyword'];
			$description = strip_tags( $product['description'] );
			$img_url = $product['image_url'];
			$image_thumb_url = $product['image_thumb_url'];
			if ( $show_thumbnails && '' != $image_thumb_url )
				$img_url = $image_thumb_url;
			$affiliate_url = $product['affiliate_url'];
			$price = $product['price'];
			$sale_price = $product['price_sale'];
			$currency = $product['currency'];
			$category = $product['category'];
			$merchant = $product['merchant'];
			$brand = $product['brand'];
			$upc = $product['upc'];
			$isbn = $product['isbn'];
			$sales = $product['sales'];

			// tweaks..
			if ( '' != $link_cloak_folder )
				$affiliate_url = trailingslashit( get_bloginfo( 'url' ) ) . $link_cloak_folder . str_replace( 'http://prosperent.com/affiliate/click', '', $affiliate_url );
			$follow = ( $nofollow_links ) ? ' rel="nofollow"' : '';
			$target = ( $new_window ) ? ' target="_blank"' : '';
			$price = $this->get_currency_symbol( $product['currency'] ) . $product['price'];
			$sale_price = $this->get_currency_symbol( $product['currency'] ) . $product['price_sale'];

			switch( $template ) {

				case 'default':
					$output .= '<div class="nmtk-prosperent-item nmtk-clear">';
					if ( $show_title )
						$output .= '<div class="nmtk-prosperent-item-title"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'">'.$title.'</a></div>';
					if ( $show_image )
						$output .= '<div class="nmtk-prosperent-item-image" style="max-width:'.$max_image_size.'px;"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'"><img src="'.$img_url.'" alt="'.$title.'" style="max-width:'.$max_image_size.'px;max-height:'.$max_image_size.'px;" /></a></div>';
					if ( $show_price ) {
						if ( $show_sale_price && intval( $product['price_sale'] ) > 0 )
							$output .= '<span class="nmtk-prosperent-item-price line-through"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span> <span class="nmtk-prosperent-item-sale-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Sale Price: '.$sale_price.'!">'.$sale_price.'</a></span>';
						else
							$output .= '<span class="nmtk-prosperent-item-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span>';
					}// end if
					if ( $show_details_link )
						$output .= '<span class="nmtk-prosperent-item-view-details"><a href="'.$affiliate_url.'"'.$follow.$target.' title="View details">View details</a></span>';
					if ( $show_buy_link )
						$output .= '<span class="nmtk-prosperent-item-buy-now"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Buy Now">Buy Now</a></span>';
					if ( $show_merchant )
						$output .= '<span class="nmtk-prosperent-item-merchant">'.$merchant.'</span>';
					if ( $show_description )
						$output .= '<div class="nmtk-prosperent-item-description">'.$description.'</div>';
					$output .= "</div>\n";
					break;
				
				case 'classic':
					$output .= '<div class="nmtk-prosperent-item nmtk-clear">';
					if ( $show_title )
						$output .= '<div class="nmtk-prosperent-item-title"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'">'.$title.'</a></div>';
					if ( $show_image )
						$output .= '<a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'" class="nmtk-prosperent-item-image" style="max-width:'.$max_image_size.'px;"><img src="'.$img_url.'" alt="'.$title.'" style="max-width:'.$max_image_size.'px;max-height:'.$max_image_size.'px;" /></a>';
					$output .= '<table class="nmtk-prosperent-item-links"><tr>';
					if ( $show_price ) {
						if ( $show_sale_price && intval( $product['price_sale'] ) > 0 )
							$output .= '<td class="nmtk-prosperent-item-price">Price: <a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'"><span class="line-through">'.$price.'</span></a></td> <td class="nmtk-prosperent-item-sale-price">Sale Price: <a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$sale_price.'</a></td>';
						else
							$output .= '<td class="nmtk-prosperent-item-price">Price: <a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></td>';
					}// end if
					if ( $show_details_link )
						$output .= '<td class="nmtk-prosperent-item-view-details"><a href="'.$affiliate_url.'"'.$follow.$target.' title="View Details"><img src="'.$this->url.'viewdetails.png" border="0" alt="View Details" /></a></td>';
					if ( $show_buy_link )
						$output .= '<td class="nmtk-prosperent-item-buy-now"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Buy Now"><img src="'.$this->url.'buynow.png" border="0" alt="Buy Now" /></a></td>';
					if ( $show_merchant )
						$output .= '<td class="nmtk-prosperent-item-merchant">'.$merchant.'</td>';
					$output .= '</table>';
					if ( $show_description )
						$output .= '<div class="nmtk-prosperent-item-description">'.$description.'</div>';
					$output .= "</div>\n";
					break;

				case 'comparison':
					$output .= '<table class="nmtk-prosperent-item"><tr>';
					if ( $show_image )
						$output .= '<td class="nmtk-prosperent-item-image" style="width:'.$max_image_size.'px;"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'"><img src="'.$img_url.'" alt="'.$title.'" style="max-width:'.$max_image_size.'px;max-height:'.$max_image_size.'px;" /></a></td>';
					$output .= '<td class="nmtk-prosperent-item-text">';
					if ( $show_title )
						$output .= '<div class="nmtk-prosperent-item-title"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'">'.$title.'</a></div>';
					if ( $show_description )
						$output .= '<div class="nmtk-prosperent-item-description">'.$description.'</div>';
					$output .= '</td><td class="nmtk-prosperent-item-prices">';
					if ( $show_price ) {
						if ( $show_sale_price && intval( $product['price_sale'] ) > 0 )
							$output .= '<span class="nmtk-prosperent-item-price line-through"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span> <span class="nmtk-prosperent-item-sale-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Sale Price: '.$sale_price.'!">'.$sale_price.'</a></span>';
						else
							$output .= '<span class="nmtk-prosperent-item-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span>';
					}// end if
					if ( $show_details_link )
						$output .= '<div class="nmtk-prosperent-item-view-details"><a href="'.$affiliate_url.'"'.$follow.$target.' title="View Details"><img src="'.$this->url.'viewdetails.png" border="0" alt="View Details" /></a></div>';
					if ( $show_buy_link )
						$output .= '<div class="nmtk-prosperent-item-buy-now"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Buy Now"><img src="'.$this->url.'buynow.png" border="0" alt="Buy Now" /></a></div>';
					if ( $show_merchant )
						$output .= '<div class="nmtk-prosperent-item-merchant">'.$merchant.'</div>';
					$output .= "</td></tr></table>\n";
					break;

				case 'gallery':
					$output .= '<div class="nmtk-prosperent-item">';
					if ( $show_image )
						$output .= '<div class="nmtk-prosperent-item-image" style="height:'.$max_image_size.'px;"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'"><img src="'.$img_url.'" alt="'.$title.'" style="max-width:'.$max_image_size.'px;max-height:'.$max_image_size.'px;" /></a></div>';
					if ( $show_title )
						$output .= '<div class="nmtk-prosperent-item-title"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$title.'">'.$title.'</a></div>';
					if ( $show_description )
						$output .= '<div class="nmtk-prosperent-item-description">'.$description.'</div>';
					if ( $show_price ) {
						$output .= '<div class="nmtk-prosperent-item-prices">';
						if ( $show_sale_price && intval( $product['price_sale'] ) > 0 )
							$output .= '<span class="nmtk-prosperent-item-price line-through"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span> <span class="nmtk-prosperent-item-sale-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Sale Price: '.$sale_price.'!">'.$sale_price.'</a></span>';
						else
							$output .= '<span class="nmtk-prosperent-item-price"><a href="'.$affiliate_url.'"'.$follow.$target.' title="'.$price.'">'.$price.'</a></span>';
						$output .= '</div>';
					}// end if
					if ( $show_details_link )
						$output .= '<div class="nmtk-prosperent-item-view-details"><a href="'.$affiliate_url.'"'.$follow.$target.' title="View Details"><img src="'.$this->url.'viewdetails.png" border="0" alt="View Details" /></a></div>';
					if ( $show_buy_link )
						$output .= '<div class="nmtk-prosperent-item-buy-now"><a href="'.$affiliate_url.'"'.$follow.$target.' title="Buy Now"><img src="'.$this->url.'buynow.png" border="0" alt="Buy Now" /></a></div>';
					if ( $show_merchant )
						$output .= '<div class="nmtk-prosperent-item-merchant">'.$merchant.'</div>';
					$output .= '</div>';
					break;

				case 'custom':
					$search = array('$title', '$description', '$img_url', '$image_thumb_url', '$affiliate_url', '$price', '$sale_price', '$currency', '$category', '$merchant', '$brand', '$upc', '$isbn', '$sales');
					$replace = array($title, $description, $img_url, $image_thumb_url, $affiliate_url, $price, $sale_price, $currency, $category, $merchant, $brand, $upc, $isbn, $sales);
					$output .= str_replace( $search, $replace, $custom_template );
					break;

			}// end switch

		}// end foreach

		if ( $show_pagination ) {
			$output .= '<div class="nmtk-prosperent-pagination">';
			$output .= 'Pages: ';
			$output .= '</div><!-- /nmtk-prosperent-pagination -->';
		}// end if

		$output .= '</div><!-- /nmtk-prosperent -->';
		
		return $output;

	}// end func

	function get_api_response( $parameters ) {
		$url = 'http://api.prosperent.com/api/search?' . $parameters;
		parse_str( $parameters, $params );
		$query = $params['query'];
		$response = wp_remote_fopen( $url );
		if ( $response ) {
			// if we got a sensible response..
			if ( false !== strpos( $response, 'errors' ) ) {
				// decode..
				$json = json_decode( $response, $array = true );
				// if we got errors..
				if ( $json['errors'] )
					$errors[] = $json['errors'][0]['msg'];
				else {
					// if ok, cache this response..
					if ( is_array( $json['data'] ) && count( $json['data'] ) && strlen( $json['countryCode'] ) ) {
						$transient_key = 'nmtk_' . $json['countryCode'] . '_' . sanitize_file_name( $query );
						$cached_response = get_transient( $transient_key );
						if ( !$cached_response ) {
							set_transient( $transient_key, $response, 86400 );
							$_SESSION['country_code'] = $json['countryCode'];
							return $response;
						}
						else
							return $cached_response;
					}// end if
				}// end if
			}// end if
		}// end if
		return $response;
	}// end func

	function get_currency_symbol( $currency_code ) {
		if ( 'GBP' == $currency_code )
			return '&#163;';
		elseif ( 'EUR' == $currency_code )
			return '&#128;';
		else
			return '&#36;';
	}// end func

	function show_error( $error, $echo = false ) {
		if ( $echo )
			return '<p class="nmtk-error">'.$error.'</p>';
		else
			return;
	}// end func

	function get_query_from_referer( $referer ) {

		$query = false;
		$referer = trim( rawurldecode( $referer ) );
		$referer = preg_replace( '/\\s/', '%20', $referer );

		if ( strlen( $referer ) ) {
		
			$referer = parse_url( $referer );
			
			if ( strlen( $referer['host'] ) && strlen( $referer['query'] ) ) {

				parse_str( $referer['query'], $queries );
			
				$search_engines = array(
					'.alltheweb.com' => array('q'),
					'.altavista.' => array('q'),
					'.ask.co' => array('ask','q'),
					'.baidu.com' => array('wd','word','kw'),
					'.bing.com' => array('q'),
					'.blogdigger.com' => array('q'),
					'.blogpulse.com' => array('query'),
					'.cuil.com' => array('q'),
					'.exalead.' => array('q'),
					'.excite.' => array('q','search'),
					'.facebook.com' => array('q'),
					'.gigablast.com' => array('q'),
					'.gmx.net' => array('su'),
					'.google.' => array('q','as_q'),
					'.hotbot.' => array('query'),
					'.icq.com' => array('q'),
					'.infoseek.' => array('qt'),
					'.live.com' => array('q'),
					'.looksmart.com' => array('key'),
					'.lycos.' => array('query'),
					'.mister-wong.' => array('keywords'),
					'.monstercrawler.com' => array('qry'),
					'.mozbot.' => array('q'),
					'.msn.' => array('q'),
					'.mysearch.' => array('searchfor'),
					'.netscape.' => array('q','query','search'),
					'.openfind.com' => array('query'),
					'.overture.com' => array('Keywords'),
					'.search.ch' => array('q'),
					'.search.com' => array('q'),
					'.searchy.co' => array('search_term'),
					'.seek.fr' => array('qry_str'),
					'.setooz.com' => array('query'),
					'.sharelook.' => array('keyword'),
					'.sympatico.' => array('q'),
					'.t-online.de' => array('q'),
					'.teoma.com' => array('t'),
					'.tiscali.' => array('key','query'),
					'.voila.' => array('kw'),
					'.websearch.com' => array('q','qkw'),
					'.yahoo.' => array('p'),
					'.yandex.' => array('text'),
					'alexa.com' => array('q'),
					'daemon-search.com' => array('q'),
					'data.quicksearches.net' => array('q'),
					'digg.com' => array('s'),
					'dmoz.org' => array('search'),
					'dogpile.com' => array('q'),
					'firstsfind.com' => array('qry'),
					'forestle.org' => array('q'),
					'friendfeed.com' => array('q'),
					'ixquick.' => array('query'),
					'mamma.com' => array('query'),
					'online.no' => array('q'),
					'search.about.com' => array('terms'),
					'search.aol' => array('query','q'),
					'search.babylon.com' => array('q'),
					'search.bluewin.ch' => array('searchTerm'),
					'search.comcast.net' => array('q'),
					'search.conduit.com' => array('q'),
					'search.earthlink.net' => array('q'),
					'search.metacrawler.com' => array('general'),
					'search.naver.com' => array('query'),
					'search.nifty.com' => array('q'),
					'search.opera.com' => array('search'),
					'search.virginmedia.' => array('q'),
					'searchalot.com' => array('q'),
					'searchscout.com' => array('gt_keywords'),
					'searchservice.myspace' => array('qry'),
					'websearch.cs.com' => array('query'),
					'localhost' => array('x')
					);

				foreach ( $search_engines as $engine => $params ) {

					if ( false !== strpos( $referer['host'], $engine ) ) {

						foreach ( $params as $param ) {

							if ( array_key_exists( $param, $queries ) )
								$query = trim( rawurldecode( urldecode( $queries[$param] ) ) );
						
						}// end foreach
					
					}// end if
				
				}// end foreach

			}// end if
		
		}// end if

		return $query;

	}// end func
	
	function wp_head() {
		echo '<link rel="stylesheet" href="'.$this->url.'plugin.css" type="text/css" />'."\n";
		echo "<style type='text/css'>\n"
			. ".nmtk-prosperent-classic .nmtk-prosperent-item-image {background:transparent url('".$this->url."shadow.png') no-repeat center bottom;}\n";
		$options = $this->get_options();
		echo stripslashes( $options['custom_css'] );
		echo "</style>\n";
	}// end function

	function spit( $label, $value = null ) {
		if ( $value )
			echo "<span style='font-weight:bold;'>$label:</span> $value<br />";
		else
			echo "<span>$label<br />";
	}// end func

	function boolval( $var = null ) {
		if ( is_bool( $var ) )
			return $var;
		elseif ( is_numeric( $var ) ) {
			$var = intval( $var );
			return ( $var != 0 ) ? true : false;
		}
		elseif ( is_string( $var ) ) {
			$var = trim( strtolower( $var ) );
			return ( $var == 'true' || $var == 'yes' || $var == 'on' ) ? true : false;
		}
		else
			return false;
	}// end func

	function get_transient_key( $country_code, $keyword, $sort_by ) {
		$result = false;
		$sort_by = trim( preg_replace('/\s+/', ' ', $sort_by ), " @\t\n\r\0\x0B" );
		$sort = substr( $sort_by, 0, 2 );
		$order = strpos( $sort_by, ' ' );
		if ( false !== $order )
			$sort .= substr( $sort_by, $order + 1, 1 );
		$key = $country_code . $keyword . '_' . $sort;
		$key = 'nmtk_' . preg_replace('/\s+/', '', $key );
		// wp_options table only gives us 64 chars to play with and
		// 19 are taken up by transient labels.. so we got 45 left..
		if ( strlen( $key ) < 46 )
			$result = $key;
		return $result;
	}// end func
	
	function template_redirect() {

		if ( is_404() && '' != $_SERVER['REQUEST_URI'] ) {

			$options = $this->get_options();
			if ( '' != $options['link_cloak_folder'] ) {

				$folder = '/' . $options['link_cloak_folder'] . '/';
				if ( false !== strpos( $_SERVER['REQUEST_URI'], $folder ) ) {

					$click = substr( $_SERVER['REQUEST_URI'], strpos( $_SERVER['REQUEST_URI'], $folder ) + strlen( $folder ) );
					$destination = 'http://prosperent.com/affiliate/click/' . $click;

					// 302 redirect..
					wp_redirect( $destination, 302 );
					exit;

				}// end if

			}// end if
		
		}// end if

	}// end function

	function get_options() {
		$options = get_option('nmtk_prosperent');
		if ( !is_array($options) )
			$options = $this->set_defaults();
		return $options;
	}// end function
	
	function set_defaults() {
		$options = array(
			'api_key' => '',
			'channel_id' => '',
			'debug_mode' => false,
			'use_search_referrer' => false,
			'keyword' => '',
			'sort_by' => '@relevance DESC',
			'show_search' => true,
			'show_sortby' => true,
			'template' => 'default',
			'show_title' => true,
			'show_image' => true,
			'show_description' => true,
			'show_price' => true,
			'show_sale_price' => true,
			'show_details_link' => true,
			'show_buy_link' => true,
			'show_merchant' => true,
			'max_ads' => 10,
			'max_image_size' => 100,
			'show_thumbnails' => true,
			'single_only' => false,
			'custom_css' => '',
			'custom_template' => '',
			'link_cloak_folder' => '',
			'nofollow_links' => true,
			'new_window' => false,
			'country' => 'auto'
		);
		update_option('nmtk_prosperent', $options);
		return $options;
	}// end function

}// end class
$nmtk_prosperent = new nmtk_prosperent;

if ( is_admin() )
	include_once dirname(__FILE__).'/admin.php';
