<?php
/*
* Logging
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/rss_log.php');

require_once(dirname(__FILE__) . '/other_functions.php');

function wtg_log() {
	if (isset($_POST['empty'])) {
		$rdb = new WTG_DB();
		$rdb->empty_log();
	}
	$result=wtg_get_version(WTG_UPGRADE_VERSION_URL);
	$version_message;
	if(version_compare($result, WTG_CURRENT_VERSION, '>')) {
		$version_message='An upgrade v'.$result.' is available for download.';
	}
	$wtg_option = get_option('wtg_option');
	$logger = new WTG_Rss_Log();
	if (isset($_POST['logemail'])) {
		if (!empty($_POST['email']) && !is_email(trim($_POST['email']))) {
			$error = 'Please input a valid email address.';
		}
		if($version_message) {
			$message="\n".$version_message."\n\n";
		}
		$wtg_option['email'] = trim($_POST['email']);
		if (!empty($_POST['latest'])) {
			$wtg_option['latest'] = 1;
            if (!empty($wtg_option['email']) && !empty($wtg_option['latest'])) {
            	if($logger->get_latest_log_text()) {
			wp_mail($wtg_option['email'], 'Latest RSS feed submission log', $message.$logger->get_latest_log_text());
		}
            }
		} else {
			$wtg_option['latest'] = 0;
		}
		if (!empty($_POST['complete'])) {
			$wtg_option['complete'] = 1;
            if (!empty($wtg_option['email']) && !empty($wtg_option['complete'])) {
            	if($logger->get_latest_log_text()) {
			wp_mail($wtg_option['email'], 'Complete RSS feed submission log', $message.$logger->get_complete_log_text());
		}
            }
		} else {
			$wtg_option['complete'] = 0;
		}
		if (empty($error)) {
			update_option('wtg_option', $wtg_option);
			echo '<div class="updated fade"><p>Options saved.</p></div>';
		} else {
			echo '<div class="error"><p>' . $error . '</p></div>';
		}
	}
	$wtg_option = get_option('wtg_option');
	wtg_db_check_and_create();
	wtg_messages();
?>

<form method="post">
	<p class="submit">
		<input type="submit" name="empty" value="Empty Log &raquo;" />
	</p>
	<p>Enter the email address below you would like to receive a copy of the log from the most current operation each time you post. Click all checkboxes if you want the complete log sent as well.</p>
		<p>
			<input type="text" name="email" value="<?php echo empty($wtg_option['email'])?'':$wtg_option['email']; ?>" />
			Latest Log<input type="checkbox" <?php echo !empty($wtg_option['latest']) ?'checked':''; ?> name="latest" value="1" />
			Complete Log<input type="checkbox" <?php echo !empty($wtg_option['complete']) ?'checked':''; ?> name="complete" value="1" />
		</p>
		<p class="submit">
			<input type="submit" name="logemail" value="Send" />
		</p>
	<div class="wrap">
		<h2>The log from the previous operation</h2>
		<p class="code">
			<?php
			$logs =  $logger->get_latest_log();
			foreach ($logs as $log) {
				echo $log->time . '&nbsp;' . (htmlspecialchars($log->message)) . "<br />";
			}
			?>
		</p>
		<h2>The last 200 lines of the complete log</h2>
		<p class="code">
			<?php
			$logs =  $logger->get_complete_log(200);
			foreach ($logs as $log) {
				echo $log->time . '&nbsp;' . (htmlspecialchars($log->message)) . "<br />";
			}
			?>
		</p>
	</div>
</form>
<?php

}