<?php
/*
* Aggregator Class
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/php5_functions.php');
require_once(dirname(__FILE__) . '/simplexml.php');

if(!class_exists('WTG_Aggregator')):

class WTG_Aggregator {

	var $dom;
	var $simple_xml;
	var $aggregators;
	var $agg_details;
	
	function initDB() {
		global $wpdb;
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$this->aggregators = $wpdb->get_results( "SELECT * FROM ".$table_name_aggregators." ORDER BY `id` ASC " );
		$this->agg_details = $wpdb->get_results( "SELECT * FROM ".$table_name_agg_submit." ORDER BY `id` ASC " );
	}
	
	function searchAggNameDB($name)
	{
		global $wpdb;
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		
		foreach ($this->get_all_aggregatorsDB() as $aggregator) {
			if (strcmp($aggregator->name, $name) == 0) {
				return $aggregator;
			}
		}
	}
	
	function get_all_aggregatorsDB() {
		return $this->aggregators;
	}
	
	function get_all_agg_detailsDB() {
		return $this->agg_details;
	}
	
	function get_aggregatorDB($id) {
		foreach ($this->get_all_aggregatorsDB() as $aggregator) {
			if (strcmp($aggregator->id, $id) == 0) {
				return $aggregator;
			}
		}
		return false;
	}
	
	function get_aggregatorDetailsDB($id) {
		foreach ($this->get_all_agg_detailsDB() as $aggregator) {
			if (strcmp($aggregator->id, $id) == 0) {
				return $aggregator;
			}
		}
		return false;
	}
	
	function reverse_statusDB($id) {
		global $wpdb;
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		foreach ($this->get_all_aggregatorsDB() as $aggregator) {
			if ($aggregator->id == $id) {
				$result = ($aggregator->enabled == 0) ? 1 : 0;
				$wpdb->update( $table_name_aggregators , array( 'enabled' => $result ), array( 'id' => $aggregator->id ));
				break;
			}
		}
		return false;
	}
	
	function get_aggregator_login_stepDB($aggregator_id) {
		$agg_details = $this->get_aggregatorDetailsDB($aggregator_id);
		$steps = unserialize($agg_details->steps);
		if (isset($steps[1])) return $steps[1];
		return false;
	}
	
	function get_aggregator_add_feed_stepDB($aggregator_id) {
		$agg_details = $this->get_aggregatorDetailsDB($aggregator_id);
		$steps = unserialize($agg_details->steps);
		if (isset($steps[2])) return $steps[2];
		return false;
	}
	
	function get_aggregator_step_by_orderDB($aggregator_id, $order) {
		$agg_details = $this->get_aggregatorDetailsDB($aggregator_id);
		$steps = unserialize($agg_details->steps);
		if (isset($steps[$order])) return $steps[$order];
		return false;
	}
	
	function set_aggregator_stepsDB($args, $id) {
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$agg_details = $this->get_aggregatorDetailsDB($id);
		$steps = unserialize($agg_details->steps);
		
		$newSteps = array();
		for ($i = 0; $i < count($args['order']); $i++) {

			$order = $i + 1;
			$newSteps[$order]['formIDType']  = $args['formIDType'][$i];
			$newSteps[$order]['url']		 = $args['url'][$i];
			$newSteps[$order]['formIDValue'] = $args['formIDValue'][$i];
			$newSteps[$order]['successRegx'] = $args['successRegx'][$i];
		}
		
		for ($i = 0; $i < count($args['order']); $i++) {
			$order = $i + 1;
			$steps[$order]['formIDType']  = $newSteps[$order]['formIDType'];
			$steps[$order]['url']		  = $newSteps[$order]['url'];
			$steps[$order]['formIDValue'] = $newSteps[$order]['formIDValue'];
			$steps[$order]['successRegx'] = $newSteps[$order]['successRegx'];
		}
		
		for ($i = 1 ; $i <= 3 ; $i++)
			if (($steps[$i]['url'] == "") && ($steps[$i]['formIDValue'] == "") && ($steps[$i]['successRegx'] == ""))
				unset($steps[$i]);
		
		$serializedData = serialize($steps);
		$wpdb->update( $table_name_agg_submit , array( 'steps' => $serializedData ), array( 'id' => $id ));
	}
	function get_aggregator_paramsDB($aggregator_id, $order) {
		$agg_details = $this->get_aggregatorDetailsDB($aggregator_id);
		$steps = unserialize($agg_details->steps);
		if (isset($steps[$order])) return $steps[$order]['params'];
		return false;
	}
	
	function get_aggregator_paramDB($aggregator_id, $order, $param_index = 0) {
		$params = $this->get_aggregator_paramsDB($aggregator_id, $order);
		if (empty($params)) return false;
		if (isset($params[$param_index])) {
			return $params[$param_index];
		}
		return false;
	}
	
	function set_aggregator_paramsDB($ag_id, $order_id, $args) {
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		
		$agg_details = $this->get_aggregatorDetailsDB($ag_id);
		$steps = unserialize($agg_details->steps);
		$step = $steps[$order_id];
		//echo "<pre>";print_r($newParams);echo "</pre>";
		$newParams = array();
		for ($i = 0; $i < count($args['paramName'][0]); $i++) {
			if ($args['paramName'][0][$i] != "")
			{
				$newParams[$i]['param_name']  = $args['paramName'][0][$i];
				$newParams[$i]['param_type'] = $args['paramType'][0][$i];
				$newParams[$i]['param_value'] = $args['paramValue'][0][$i];
				$arg = $args['paramName'][0][$i];
			}
			
		}
		
		if (($order_id == 1) && ($args['paramValue'][0][0] != ""))
		{
			if ($args['paramValue'][0][0] != "")
				$wpdb->update( $table_name_aggregators , array( 'isReady' => 1 ), array( 'id' => $ag_id ));
			else
				$wpdb->update( $table_name_aggregators , array( 'isReady' => 0 ), array( 'id' => $ag_id ));
		}
		//echo "<pre>";print_r($newParams);echo "</pre>";
		$steps[$order_id]['params'] = $newParams;
		$serializedData = serialize($steps);
		$wpdb->update( $table_name_agg_submit , array( 'steps' => $serializedData ), array( 'id' => $ag_id ));
	}
	
	function add_a_profileDB($ag_id, $order_id) {
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$agg_details = $this->get_aggregatorDetailsDB($ag_id);
		$steps = unserialize($agg_details->steps);
		$step = $steps[$order_id];
		//echo "<pre>";print_r($steps[$order_id]['params']);echo "</pre>";
		$count = 0;
		foreach($steps[$order_id]['params'] as $params)
		{
			$count++;
			$newParams = array();
			$newParams['param_name'] = $params['param_name'];
			$newParams['param_type'] = $params['param_type'];
			$newParams['param_value'] = '';
			$steps[$order_id]['params'][] = $newParams;
			
			if ($count == 2)
				break;
		}
		//echo "after: <br/>";
		//echo "<pre>";print_r($steps[$order_id]['params']);echo "</pre>";
		$serializedData = serialize($steps);
		$wpdb->update( $table_name_agg_submit , array( 'steps' => $serializedData ), array( 'id' => $ag_id ));

	}
	
	function delete_aggregatorDB($id) {
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		$wpdb->query("DELETE FROM ".$table_name_aggregators." where id=".$id);
		$wpdb->query("DELETE FROM ".$table_name_agg_submit." where id=".$id);
	}
	
	function wtg_parse_aggregators_xml($aggregators_xml) {
		$this->simple_xml = new MySimpleXML();
		return $this->simple_xml->xml_load_string($aggregators_xml, 'array');
	}
	
	function delete_a_profileDB($ag_id, $order_id, $param_index) {
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$agg_details = $this->get_aggregatorDetailsDB($ag_id);
		$steps = unserialize($agg_details->steps);
		$step = $steps[$order_id];
		unset($steps[$order_id]['params'][$param_index]);
		unset($steps[$order_id]['params'][$param_index + 1]);
		
		$serializedData = serialize($steps);
		$wpdb->update( $table_name_agg_submit , array( 'steps' => $serializedData ), array( 'id' => $ag_id ));
	}
	
	function get_status_disabledDB($name) {
		global $wpdb;
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		foreach ($this->get_all_aggregatorsDB() as $aggregator) {
			if ($aggregator->name == $name) {
				$wpdb->update( $table_name_aggregators , array( 'enabled' => 0 ), array( 'id' => $aggregator->id ));
				break;
			}
		}
		return false;
	}
	
	function get_db2xml() 
	{
		global $wpdb;
		$table_name_agg_submit = $wpdb->prefix . "_wtg_agg_submit";
		$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
		$ag = new WTG_Aggregator();
		$ag->initDB();
		$agg_content = '';
		ob_start();
?>
<?php echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.'>'; ?>
<root>	
<?php
	foreach ($ag->get_all_aggregatorsDB() as $aggregator) {
		$agg_details = $ag->get_aggregatorDetailsDB($aggregator->id);
		$steps = unserialize($agg_details->steps);
	?>
<aggregator enabled="<?php echo ($aggregator->enabled == '1')? 'true':  'false'; ?>" >
		<id><?php echo htmlspecialchars($aggregator->id); ?></id>
		<name><?php echo htmlspecialchars($aggregator->name); ?></name>
		<?php foreach ($steps as $order => $step) {
				$params = $step['params'];
		?>
	<step>
			<order><?php echo $order; ?></order>
			<params>
			<?php foreach ($params as $param) { ?>
	<param type="<?php echo $param['param_type']; ?>">
					<name><?php echo htmlentities($param['param_name']); ?></name>
					<?php
						if ($param['param_value'] != "")
						{
					?>
<value><?php echo htmlentities($param['param_value']); ?></value>
				<?php } ?>
</param>
			<?php }	?>
</params>
			<url formIDType="<?php echo $step['formIDType']; ?>" formIDValue="<?php echo $step['formIDValue']; ?>" method="POST"><?php echo htmlentities($step['url']); ?></url>
			<successRegx><?php echo $step['formIDType']; ?></successRegx>
		</step>
	<?php } ?>		
	</aggregator>
	<?php	
	}
?>
</root>

<?php
		$feed_content = ob_get_contents();
		ob_end_clean();
		$wtg_option = get_option('wtg_option');
		
		if(wtg_path_is_absolute($wtg_option['feedDir'])) {
			$feed_absdir = $wtg_option['feedDir'] . '/';
		} else {
			$feed_absdir = wtg_detect_doc_root() . '/' . $wtg_option['feedDir'] . '/';
		}
		
		$feed_name = "extrafeeds_backup.xml";
		
		file_put_contents($feed_absdir . $feed_name, $feed_content);
		
		return file_get_contents($feed_absdir . $feed_name);
	}
	
	//////////////////////////////////////////////////////

	function init() {
		$aggregators_xml = file_get_contents(AGGREGATORS_XML_TEMPLATE);
		if (empty($aggregators_xml)) return false;
		$this->dom = $this->_parse_aggregators_xml($aggregators_xml);
		return true;
	}

	function get_all_aggregators() {
		return wtg_to_array($this->dom['aggregator']);
	}

	function get_xml() {
		return file_get_contents(AGGREGATORS_XML_TEMPLATE);
	}

	function get_aggregator($id) {
		foreach ($this->get_all_aggregators() as $aggregator) {
			if (strcmp($aggregator['id'], $id) == 0) {
				return $aggregator;
			}
		}
		return false;
	}

	function reverse_status($id) {
		$aggregators = &$this->dom['aggregator'];
		foreach ($aggregators as $k => $aggregator) {
			if ($aggregator['id'] == $id) {
				if($aggregators[$k]['@attributes']['enabled'] == 'false') {
				}
				$aggregators[$k]['@attributes']['enabled'] = $aggregator['@attributes']['enabled'] == 'false' ? 'true' : 'false';
				return $this->_update();
			}
		}
		return false;
	}

	function _update() {
		$aggregators_xml = $this->simple_xml->asXML($this->dom);
		return file_put_contents(AGGREGATORS_XML_TEMPLATE, $aggregators_xml);
	}

	function _parse_aggregators_xml($aggregators_xml) {
		$this->simple_xml = new MySimpleXML();
		return $this->simple_xml->xml_load_string($aggregators_xml, 'array');
	}

	function get_aggregator_login_step($aggregator_id) {
		$aggregator = $this->get_aggregator($aggregator_id);
		foreach (wtg_to_array($aggregator['step']) as $step) {  // lcr & ajb
			if (isset($step['url']['@attributes']['name']) && $step['url']['@attributes']['name'] == 'login') {
				return $step;
			}
		}
		return false;
	}

	function get_aggregator_add_feed_step($aggregator_id) {
		$aggregator = $this->get_aggregator($aggregator_id);
		foreach (wtg_to_array($aggregator['step']) as $step) {
			if (isset($step['url']['@attributes']['name']) && $step['url']['@attributes']['name'] == 'addFeed') {
				return $step;
			}
		}
		return false;
	}

	function get_aggregator_step_by_order($aggregator_id, $order) {
		$aggregator = $this->get_aggregator($aggregator_id);
		foreach (wtg_to_array($aggregator['step']) as $step) {
			if ($step['order'] == $order) {
				return $step;
			}
		}
		return false;
	}

	function add_aggregator($name, $enabled = 'false') {
		$id = strtoupper(substr(md5(strval(time())), 0, 5));
		$aggregator = array();
		$aggregator['@attributes']['enabled'] = $enabled;
		$aggregator['id'] = $id;
		$aggregator['name'] = trim($name);
		$this->dom['aggregator'][] = $aggregator;
		return $this->_update() ? $id : false;
	}

	function get_aggregator_steps($id) {
		$aggregator = $this->get_aggregator($id);
		if (!isset($aggregator['step'])) 
			return false;
		return wtg_to_array($aggregator['step']);
	}

	function _add_a_url(&$step, $args, $i) {
		$url = array();
		$url['@content'] = trim($args['url'][$i]);
		$url['@attributes']['formIDType'] = trim($args['formIDType'][$i]);
		$url['@attributes']['formIDValue'] = trim($args['formIDValue'][$i]);
		if(isset($args['method'][$i])) {
			$url['@attributes']['method']= trim($args['method'][$i]);
		} else {
			$url['@attributes']['method']= "POST";
		}
		if ($args['order'][$i] == 1) {
			$url['@attributes']['name'] = 'login';
		} elseif ($args['order'][$i] == 2) {
			$url['@attributes']['name'] = 'addFeed';
		}
		$step['url'] = $url;
		$step['successRegx'] = trim(stripslashes($args['successRegx'][$i]));
	}

	function _add_a_step(&$aggregator, $args, $i) {
		if (strlen(trim($args['url'][$i])) == 0) 
			return;
		$step = array();
		$step['order'] = $args['order'][$i];
		$this->_add_a_url($step, $args, $i);
		$aggregator['step'][] = $step;
	}

	function set_aggregator_steps($args) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $ag) {
			if ($ag['id'] == $args['id']) {
				$aggregator = &$this->dom['aggregator'][$k];
				break;
			}
		}
		for ($i = 0; $i < count($args['order']); $i++) {
			foreach (wtg_to_array($aggregator['step']) as $k => $st) {
				if ($st['order'] == $args['order'][$i]) {
					$step = &$aggregator['step'][$k];
					break;
				}
			}
			if (empty($step)) {
				$this->_add_a_step($aggregator, $args, $i);
			} else {
				if (strlen(trim($args['url'][$i])) == 0) {
					for ($k = 0; $k < count($aggregator['step']); $k++) {
						if ($aggregator['step'][$k]['order'] == $args['order'][$i]) {
							unset($aggregator['step'][$k]);
						}
					}
					continue;
				}
				// update this step, first remove url element, then add the new url elemnt
				unset($step['url']);
				unset($step['successRegx']);
				$this->_add_a_url($step, $args, $i);
			}
			unset($step);
		}
		return $this->_update();
	}

	function set_aggregator_name($id, $name) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $id) {
				$this->dom['aggregator'][$k]['name'] = trim($name);
				return $this->_update();
			}
		}
		return false;
	}

	function set_aggregator_params($ag_id, $order_id, $args) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $ag_id) {
				foreach (wtg_to_array($this->dom['aggregator'][$k]['step']) as $j => $step) {
					if ($step['order'] == $order_id) {
					$step = &$this->dom['aggregator'][$k]['step'][$j];
					break;
					}
				}
			}
		}
		unset($step['params']);
		for ($param_index = 0; $param_index < count($args['paramName']); $param_index++) {
			for ($i = 0; $i < count($args['paramName'][$param_index]); $i++) {
				if (strlen(trim($args['paramName'][$param_index][$i])) != 0) {
					$param = array();
					$param['name'] = trim($args['paramName'][$param_index][$i]);
					if($args['paramCatId'][$param_index][$i]) {
						$param['value'] = htmlspecialchars(($args['paramCatId'][$param_index][$i]));
					} else {
						$param['value'] = htmlspecialchars(($args['paramValue'][$param_index][$i]));
					}
					$param['@attributes']['type'] = trim($args['paramType'][$param_index][$i]);
					$step['params'][$param_index]['param'][] = $param;
				}
			}
		}
		return $this->_update();
	}

	function set_parameter($aggregator_id, $param_field, $v) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $aggregator_id) {
				foreach (wtg_to_array($this->dom['aggregator'][$k]['step']) as $j => $step) {
					$step = &$this->dom['aggregator'][$k]['step'][$j];
					wtg_to_array($step['params']);
					$params = &$step['params'];
					foreach ($params['param'] as $k => $param) {
						if ($param['name'] == $param_field) {
							$params['param'][$k]['value'] = $v;
							return $this->_update();
						}
					}
				}
			}
		}
	}

	function get_parameter($aggregator_id, $param_field) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $aggregator_id) {
				foreach (wtg_to_array($this->dom['aggregator'][$k]['step']) as $j => $step) {
					$step = &$this->dom['aggregator'][$k]['step'][$j];
					wtg_to_array($step['params']);
					$params = &$step['params'];
					foreach ($params['param'] as $k => $param) {
						if ($param['name'] == $param_field) {
							return $params['param'][$k]['value'] ;
						}
					}
				}
			}
		}
	}

	function delete_aggregator($id) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $id) {
				unset($this->dom['aggregator'][$k]);
				return $this->_update();
			}
		}
		return false;
	}

	function is_ready($id) {
		$login_step = $this->get_aggregator_login_step($id);
		if (empty($login_step)) return true; // login not required for this aggregator
		wtg_to_array($login_step['params']);
		$params = $login_step['params'][0]['param'];
		if (empty($params)) 
			return false; // No parameter was entered
		foreach (wtg_to_array($params) as $param) {
			if (!isset($param['value']) || strlen(trim($param['value'])) == 0) return false; // One of the parameters not entered
		}
		return true;
	}

	function get_aggregator_param($aggregator_id, $order, $param_index = 0) {
		$params = $this->get_aggregator_params($aggregator_id, $order);
		if (empty($params)) return false;
		if (isset($params[$param_index])) {
			return $params[$param_index]['param'];
		}
		return false;
	}

	function get_aggregator_params($aggregator_id, $order) {
		$aggregator = $this->get_aggregator($aggregator_id);
		foreach (wtg_to_array($aggregator['step']) as $step) {
			if ($step['order'] == $order) {
				if (!isset($step['params'])) 
					return false;
				return wtg_to_array($step['params']);
			}
		}
		return false;
	}

	function add_a_profile($ag_id, $order_id) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $ag_id) {
				foreach (wtg_to_array($this->dom['aggregator'][$k]['step']) as $j => $step) {
					if ($step['order'] == $order_id) {
						$step = &$this->dom['aggregator'][$k]['step'][$j];
						wtg_to_array($step['params']);
						$params = &$step['params'];
						$params[] = array('param' => array(
						array('@attributes' => array('type' => 'value'), 'name' => $params[0]['param'][0]['name'], 'value' => ' '),
						array('@attributes' => array('type' => 'value'), 'name' => $params[0]['param'][1]['name'], 'value' => ' ')
						));
						return $this->_update();
					}
				}
			}
		}
	}

	function delete_a_profile($ag_id, $order_id, $param_index) {
		foreach (wtg_to_array($this->dom['aggregator']) as $k => $aggregator) {
			if ($aggregator['id'] == $ag_id) {
				foreach (wtg_to_array($this->dom['aggregator'][$k]['step']) as $j => $step) {
					if ($step['order'] == $order_id) {
						$step = &$this->dom['aggregator'][$k]['step'][$j];
						wtg_to_array($step['params']);
						$params = &$step['params'];
						unset($params[$param_index]);
						return $this->_update();
					}
				}
			}
		}
	}

	function get_enablecount() {
		$count=0;
		$aggregators=$this->get_all_aggregators();
		foreach($aggregators as $k => $aggregator) {
			if ($aggregators[$k]['@attributes']['enabled']=='true') {
				$count = $count+1;
			}
		}
		return $count;
	}
	
	function get_status_disabled($name) {
		$aggregators = &$this->dom['aggregator'];
		foreach ($aggregators as $k => $aggregator) {
			if ($aggregator['name'] == $name) {
				$aggregators[$k]['@attributes']['enabled'] = 'false';
				return $this->_update();
			}
		}
		return false;
	}

}

endif;