<?php
/*
* Manage Aggregators
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2008-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/

require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/aggregator_model.php');
require_once(dirname(__FILE__) . '/aggregator_category.php');

require_once(dirname(__FILE__) . '/other_functions.php');

if (isset($_POST['enableChecked']))
{
	$values = count($_POST['aggregators']);
	$selected = $_POST['aggregators'];
	for($i = 0 ; $i < $values ; $i++)
	{
		$id = $selected[$i];
		$ag = new WTG_Aggregator();
		$ag->initDB();
		$aggregator = $ag->get_aggregatorDB($id);
		//echo "<pre>";print_r($aggregator);echo "</pre>";
		if($aggregator->enabled == 0){
			if (!empty($_POST['aggregators'][$i])) {
				$ag->reverse_statusDB($id);
			}
		} 
	}
}

if (isset($_POST['disableChecked']))
{
	$values = count($_POST['aggregators']);
	$selected = $_POST['aggregators'];
	for($i = 0 ; $i < $values ; $i++)
	{
		$id = $selected[$i];
		$ag = new WTG_Aggregator();
		$ag->initDB();
		$aggregator = $ag->get_aggregatorDB($id);
		//echo "<pre>";print_r($aggregator);echo "</pre>";
		if($aggregator->enabled == 1){
			if (!empty($_POST['aggregators'][$i])) {
				$ag->reverse_statusDB($id);
			}
		} 
	}
}

function wtg_manage_aggregators() {
	$ag = new WTG_Aggregator();
	$ag->initDB();
	
	global $wpdb;
	$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
	
	# aggregrator sites using captcha
	$captcha_site_array = array("feedage.com","jordomedia.com","bloglines.com","rss-spider.com","feedlisting.com","blogville.us","blogged.com","rssnetworkfeedsdirectory.com","rssbuffet.com","bloglisting","Submitblognow","solarwarp.net","rssmountain.com","blogbunch.com","feedcat.net","rssmicro.com","millionrss.com");
	
	$cp = new WTG_Captcha();
	$cp->initDB();
	$is_captcha_services_enabled = $cp->get_captcha_services_enabledDB();
	
	//if a captcha service is not enabled
	if(!$is_captcha_services_enabled) {
		//disable
		foreach ($ag->get_all_aggregatorsDB() as $aggregator) {
			if ($aggregator->hasCaptcha == 1)
			{
				$wpdb->update( $table_name_aggregators , array( 'isReady' => 0, 'enabled' => 0 ), array( 'id' => $aggregator->id ));
			}
		}
	}
	//if captcha service is enabled
	else
	{
		foreach ($ag->get_all_aggregatorsDB() as $aggregator) {
			if ($aggregator->hasCaptcha == 1)
			{
				$wpdb->update( $table_name_aggregators , array( 'isReady' => 1 ), array( 'id' => $aggregator->id ));
			}
		}
		
	}
	//update aggregator states
	foreach ($ag->get_all_aggregatorsDB() as $aggregator)
	{
		if ($aggregator->hasLogin == 1)
		{
			$aggregator_id = $aggregator->id;
			$agg = $ag->get_aggregatorDB($aggregator_id);
			$agg_details = $ag->get_aggregatorDetailsDB($aggregator_id);
			$steps = unserialize($agg_details->steps);
			$param = $steps[1]['params'];
			
			if (($param[0]['param_value'] == "") || ($param[1]['param_value'] == ""))
				$wpdb->update( $table_name_aggregators , array( 'isReady' => 0 ), array( 'id' => $aggregator->id ));
			else
			{
				if ($aggregator->hasCaptcha == 0)
				{
					$wpdb->update( $table_name_aggregators , array( 'isReady' => 1 ), array( 'id' => $aggregator->id ));
				}
			}
			
		}
	}
	
	if (isset($_GET['mode'])) {
		check_admin_referer('manage_aggregators');
		if ($_GET['mode'] == 'edit') {  //edit aggregator
			if (!empty($_GET['id'])) {
				wtg_edit_aggregator($_GET['id']);
				return ;
			}
		} elseif ($_GET['mode'] == 'delete') {  //delete aggregator
			$ag->delete_aggregatorDB($_GET['id']);
		} elseif ($_GET['mode'] == 'reverse') {  //reverse the status of (tgb) aggregator
			if (!empty($_GET['id'])) {
				//echo $_GET['id'];
				$ag->reverse_statusDB($_GET['id']);
			}
		}
	}
	
	wtg_display_aggregators_list();
	if(isset($_REQUEST['dv']) && ($_REQUEST['dv']=="aggregators_requiring"))
	{
		?>
			<script language="javascript">
				showloginuser();
			</script>
		<?php
	}
	if(isset($_REQUEST['dv']) && ($_REQUEST['dv']=="aggregators_requiring_all"))
	{
		?>
			<script language="javascript">
				showalluser();
			</script>
		<?php
	}
	if(isset($_REQUEST['dv']) && ($_REQUEST['dv']=="aggregators_requiring_captcha"))
	{
		?>
			<script language="javascript">
				showcaptchauser();
			</script>
		<?php
	}
	
}

function wtg_manage_params($aggregator_id, $order_id) {
	if (isset($_POST['updateParam'])) {
		_wtg_update_params($aggregator_id, $order_id);
		return true;
	} elseif (isset($_POST['addProfile'])) {
		_wtg_update_params($aggregator_id, $order_id);
		$ag = new WTG_Aggregator();
		$ag->initDB();
		$ag->add_a_profileDB($aggregator_id, $order_id);
	} elseif (isset($_POST['deleteProfile'])) {
		_wtg_update_params($aggregator_id, $order_id);
		$param_index = intval(trim($_POST['paramIndex']));
		//echo "index: ". $param_index;
		$ag = new WTG_Aggregator();
		$ag->initDB();
		$ag->delete_a_profileDB($aggregator_id, $order_id, $param_index);
	} elseif (isset($_POST['testLogin'])) {
		_wtg_update_params($aggregator_id, $order_id);
		$profile_index = intval(trim($_POST['paramIndex']));
		$result = wtg_test_login($aggregator_id, $profile_index);
	}

	// call function to show latest version information and registeration information
	wtg_messages();
	
	?>
	<div class="wrap">
		<p>Here you can input the parameters to be posted. There are two type of parameters. The first one is the value. The other is the callback function. When the type of a parameter is a callback function, the value will be what is returned from that function. Obviously, this value is dynamic. Several arguments will be passed to that function as an array: 1. The post id that triggered this submit. 2. The url which was fetched just before calling this callback function. And 3. The contents of the previous url.</p>
		<p>All valid callback functions are in <?php echo dirname(__FILE__) . '/callback_function.php'; ?></p>
		
		
		<?php
		  $ag = new WTG_Aggregator();
		  $ag->initDB();
		  $step = $ag->get_aggregator_login_stepDB($aggregator_id);
		 
		  if ($order_id == 1) {
			if (isset($result))
				wtg_display_login_params_form($aggregator_id, $order_id, $result);
			else
				wtg_display_login_params_form($aggregator_id, $order_id,"-1");
		  } else {
		  	wtg_display_params_form($aggregator_id, $order_id);
		  }
		?>
	</div>
<?php
}

function wtg_display_login_params_form($aggregator_id, $order_id, $result) {
?>
<form name="paramForm" action="" method="post">
	<input type="hidden" name="id" value="<?php echo $aggregator_id; ?>" />
	<input type="hidden" name="orderID" value="<?php echo $order_id; ?>" />
	<input type="hidden" name="paramIndex" value="0" />
	<?php
	$ag = new WTG_Aggregator();
	$ag->initDB();
	//$param = $ag->get_aggregator_paramsDB($aggregator_id, $order_id);//print_r($params);
	
	$aggregator = $ag->get_aggregatorDB($aggregator_id);
	$agg_details = $ag->get_aggregatorDetailsDB($aggregator_id);
	$steps = unserialize($agg_details->steps);
	$param = $steps[1]['params'];
	//echo "<pre>";print_r($param);echo "</pre>";
	?>
	<p><h2>Working on: <?php echo $aggregator->name; ?></h2></p>
	<?php
	$counter = 0;
	$num_of_profiles = count($param)/2;
	//echo "Number of Profiles: ". $num_of_profiles;
	for ($k = 0; $k < count($param); $k++) 
	{
		if (($k % 2) == 0 )
		{
	?>
		<div>
			<h2>Login Profile <?php echo $counter;?></h2>
		<?php for ($i = 0; $i < 2; $i++) { ?>
	    	<p>
				<label>Parameter Name:</label>
				<input type="text" name="paramName[0][]" value="<?php echo empty($param[$k + $i])?'':trim($param[$k + $i]['param_name']); ?>" readonly="readonly"/>
				<label>Parameter Type:</label>
				<select name="paramType[0][]">
					<option value="value"  <?php echo !empty($param[$k + $i]) && $param[$k + $i]['param_type'] == 'value'?'selected':''; ?> >Value</option>
					<option value="callbackFunction"  <?php echo !empty($param[$k + $i]) && $param[$k + $i]['param_type'] == 'callbackFunction'?'selected':''; ?>  >Callback Function</option>
				</select>
				<label>Parameter Value:</label>
				<input type="<?php echo $i==1?'password':'text';?>" name="paramValue[0][]" value="<?php echo empty($param[$k + $i])?'':trim($param[$k + $i]['param_value']); ?>"/>
			</p>
	    <?php } ?>
			<p class="submit"><input type="submit" name="testLogin"  value="Test Login &raquo;" onclick="document.paramForm.paramIndex.value=0;return true;" />
				<?php
					if ($num_of_profiles > 1){
				?>
					<input type="submit" name="deleteProfile" value="Delete Profile &raquo;" onclick="document.paramForm.paramIndex.value=<?php echo $k;?>;return true;" />
				<?php
					}
				?>
			</p>
		</div>
	  	<?php
			$counter ++;
			$k++;
		}
	}
	
	//echo "result: '".$result."'" ;
	if (isset($result) && (isset($_POST['paramIndex'])) && (intval(trim($_POST['paramIndex'])) == 0) ) {
		if ($result == 1) {
			echo '<div class="updated fade"><p>All logins successful.</p></div>';
		}
		else if ($result == "-1")	{}
		else {
			echo '<div class="error fade"><p>One of your logins have failed or is not filled up.</p></div>';
		}
	}
?>
	<p class="submit">
		<input type="submit" name="updateParam" value="Update Parameters &raquo;" />
		<input type="submit" name="addProfile" value="Add A Profile &raquo;" />
	</p>
</form>
<?php
}


function wtg_display_params_form($aggregator_id, $order_id){
?>
<script language="javascript" type="text/javascript">

function category_list()
{
	var chks = document.getElementsByName('paramCatbox[0][]');
	var hasChecked = false;
	var hasValue;
	for (var i = 0; i < chks.length; i++)
	{
		if (chks[i].checked)
		{
			hasChecked = true;
			var j=chks[i].value;
			var mylist=document.getElementById("cat");
			hasValue=mylist.options[mylist.selectedIndex].value;
			var arrayValue=hasValue.split('|||');
			if(arrayValue[1]) {
				document.getElementById("value"+j).value=arrayValue[1];
			} else {
				document.getElementById("value"+j).value=arrayValue[0];
			}
			document.getElementById("value"+j).value=hasValue;
			document.getElementById("catvalue"+j).value=hasValue;
		}
	}
	if (hasChecked == false)
	{
		alert("Please select at least one.");
		return false;
	}
	return true;
}
</script>
<form id="aggregators" action="" method="POST">
	<input type="hidden" name="id" value="<?php echo $aggregator_id; ?>" />
	<input type="hidden" name="orderID" value="<?php echo $order_id; ?>" />
	<?php
	$ag = new WTG_Aggregator();
	$ag->initDB();
	$aggregator = $ag->get_aggregatorDB($aggregator_id);
	$step = $ag->get_aggregator_step_by_orderDB($aggregator_id, $order_id);
	$param = $ag->get_aggregator_paramsDB($aggregator_id, $order_id);
	?>
	<p><h2>Working on: <?php echo $aggregator->name; ?></h2></p>
	<?php
	//$param = wtg_to_array($param);
	$catList=wtg_get_catlist($aggregator->name);
	for ($i = 0; $i < 10; $i++) {
		if($catList) {
			if (isset($param[$i]))
			foreach ($catList as $index => $value) {
				$catstr = $index."|||".$value;
				if($param[$i] && $param[$i]['param_value'] && $param[$i]['param_value'] == $catstr) {
					$param[$i]['CatId'] = $param[$i]['param_value'];
					$value = split("\|\|\|",$param[$i]['param_value']);
					if($value[1]) {
						$param[$i]['param_value'] = $value[1];
					} else {
						$param[$i]['param_value'] = $value[0];
					}
					break;
				}
			}
		}
    ?>
    	<p>
	    	<label>Parameter Name:</label>
			<input type="text"  name="paramName[0][]" value="<?php echo empty($param[$i])?'':trim($param[$i]['param_name']); ?>" />
	    	<label>Parameter Type:</label>
	    	<select name="paramType[0][]">
				<option value="value" <?php echo !empty($param[$i]) && $param[$i]['param_type'] == 'value'?'selected':''; ?> >Value</option>
	      		<option value="callbackFunction" <?php echo !empty($param[$i]) && $param[$i]['param_type'] == 'callbackFunction'?'selected':''; ?> >Callback Function</option>
	    	</select>
	    	<label>Parameter Value:</label>
	    	<input type="text" id="value<?=$i;?>" name="paramValue[0][]" value="<?php echo empty($param[$i])?'':trim($param[$i]['param_value']); ?>"/>
	    	<input type="hidden" id="catvalue<?=$i;?>" name="paramCatId[0][]" value="<?php echo empty($param[$i])?'':trim($param[$i]['param_value']); ?>">
<?php 
		if($catList) {
?>
			<input type="checkbox" id="cvalue<?=$i;?>" name="paramCatbox[0][]" value="<?=$i;?>"/>
<?php		
		} 
?>	    	
		</p>
  	<?php
  	}
  	$catstr='';
	if($catList) {
		foreach ($catList as $index => $value) {
			$catstr.="<option value=\"".$index."|||".$value."\" ";
			$catstr.=">".$value."</option>";
		}
		if($catstr) {
?>
			<p align="right" style="padding-right:270px;"><select id="cat" name="category" onchange="category_list();">
			<option value="">Select category</option><?=$catstr;?></select></p>
<?php
		}
	}
    ?>
	<p class="submit">
		<input type="submit" name="updateParam" value="Update Parameters &raquo;" />
	</p>
</form>
<?php
}

function _wtg_update_params($aggregator_id, $order_id)  {
	$ag = new WTG_Aggregator();
	$ag->initDB();
	if (isset($_POST['paramCatId']))
	{
		$args = array(
			'paramName' => $_POST['paramName'],
			'paramType' => $_POST['paramType'],
			'paramValue' => $_POST['paramValue'],
			'paramCatId' => $_POST['paramCatId']
		);
	}
	else{
		$args = array(
			'paramName' => $_POST['paramName'],
			'paramType' => $_POST['paramType'],
			'paramValue' => $_POST['paramValue']
		);
	}
	//echo "<pre>";print_r($args);echo "</pre>";
	if ($ag->set_aggregator_paramsDB($aggregator_id, $order_id, $args)) {
		echo '<div class="updated fade"><p>Parameters were updated.</p></div>';
		return true;
	}
	return false;
}

function _wtg_update_aggregator() {
	if (strlen(trim($_POST['name'])) == 0) {
		echo '<div class="error"><p>Please input the website name of the aggregator.</p></div>';
		return ;
	}
	$ag = new WTG_Aggregator();
	$ag->initDB();
	$args = array(
		'id' =>$_POST['id'],
		'order' => $_POST['order'],
		'url' => $_POST['url'],
		'formIDType' => $_POST['formIDType'],
		'formIDValue' => $_POST['formIDValue'],
		'successRegx' => $_POST['successRegx']
	);
	
	//$ag->set_aggregator_name($_POST['id'], trim($_POST['name']));
	for ($i = 0 ; $i < 3 ; $i++)
	{
		if (($args['url'][$i] == "") && ($args['formIDValue'][$i] == "") && ($args['successRegx'][$i] == ""))
		{
			unset($args['order'][$i]);
			unset($args['url'][$i]);
			unset($args['formIDType'][$i]);
			unset($args['formIDValue'][$i]);
			unset($args['successRegx'][$i]);
		}
	}
	$ag->set_aggregator_stepsDB($args, $_POST['id']);
	echo '<div class="updated fade"><p>Update Successfully.</p></div>';
	//return true;
}

function wtg_edit_aggregator($id){
	if (isset($_POST['updateDetail'])) {
		_wtg_update_aggregator();
	} elseif (isset($_POST['buildParam']) || isset($_POST['updateParam']) || isset($_POST['testLogin']) || isset($_POST['addProfile']) || isset($_POST['deleteProfile'])) {
		if (!wtg_manage_params($_POST['id'], $_POST['orderID'])) {
			return ;
		}
	}
	$ag = new WTG_Aggregator();
	$ag->initDB();
	$aggregator = $ag->get_aggregatorDB($id);
	$aggregatorDetails = $ag->get_aggregator_login_stepDB($id);
// call function to show latest version information and registeration information
wtg_messages();
	
?>
<div class="wrap">
	<h2>Edit Aggregator's Detail</h2>
	<p>Here you can edit the steps' information to submit rss feed to this aggregator website.</p>
	<p>Sometimes there are several forms in one page. We can identify a form in 3 way.s By the form's name, the form's id or the array index of the forms on that page. Here we use attributes formIDType and formIDValue to tell the program which form we want to post to. The success regular expression is used to validate whether the page was submitted successfully. Please use the symbol '|' to enclose the expression.</p>
	<p>Please remember to click on &quot;Update&quot; before you go to the build the posting parameters screen.</p>
	<p>Leave the url blank if that step is not required.</p>
	<form name="detailForm" action="" method="post">
		<?php wp_nonce_field('manage_aggregators');?>
		<p><h2>Working on: <?php echo $aggregator->name; ?></h2></p>
		<input type="hidden" name="orderID" />
		<input type="hidden" name="id" value="<?php echo $id;?>;" />
    	<p>
			<label>Website Name:</label>
			<input type="text" id="name" name="name" value="<?php echo $aggregator->name; ?>" readonly/>
		</p>
		<?php $step = $ag->get_aggregator_login_stepDB($aggregator->id); ?>
		<p>
			<label>Login URL:</label>
			<input type="hidden" name="order[]" value="1" />
			<input type="text" id="loginURL" name="url[]" value="<?php echo htmlspecialchars($step?$step['url']:''); ?>" />
			<label>FormID Type:</label>
			<select name="formIDType[]">
				<option value="name" <?php echo $step && $step['formIDType'] == 'name'?'selected':''?>>name</option>
				<option value="id" <?php echo $step && $step['formIDType'] == 'id'?'selected':''?>>id</option>
				<option value="index" <?php echo $step && $step['formIDType'] == 'index'?'selected':''?>>index</option>
			</select>
			<label>FormID Value:</label>
			<input type="text" id="formIDValue" name="formIDValue[]" value="<?php echo $step?$step['formIDValue']:''; ?>" />
		</p>
		<p>			
			<label>Success Regular Expression:</label>
			<input type="text" id="successRegx" name="successRegx[]" value="<?php echo htmlspecialchars($step?$step['successRegx']:''); ?>" />
			<input type="submit" name="buildParam" <?php echo $step['url']?'':'disabled="disabled"'; ?> onclick="document.detailForm.orderID.value=1;return true;" value="Update Login Details &raquo;" />
		</p>
    	<?php $step = $ag->get_aggregator_add_feed_stepDB($aggregator->id); ?>
		<p>
			<label>Add Feed URL Step 1:</label>
			<input type="hidden" name="order[]" value="2" />
			<input type="text" name="url[]" value="<?php echo htmlspecialchars($step?$step['url']:''); ?>" />
			<label>FormID Type:</label>
			<select name="formIDType[]">
				<option value="name" <?php echo $step && $step['formIDType'] == 'name'?'selected':''?>>name</option>
				<option value="id" <?php echo $step && $step['formIDType'] == 'id'?'selected':''?>>id</option>
				<option value="index" <?php echo $step && $step['formIDType'] == 'index'?'selected':''?>>index</option>
			</select>
			<label>FormID Value:</label>
			<input type="text"	 name="formIDValue[]" value="<?php echo $step?$step['formIDValue']:''; ?>" />
		</p>
		<p>
			<label>Success Regular Expression:</label>
			<input type="text" name="successRegx[]" value="<?php echo htmlspecialchars($step?$step['successRegx']:''); ?>" />
      		<input type="submit" name="buildParam" <?php echo $step?'':'disabled="disabled"'; ?> onclick="document.detailForm.orderID.value=2;return true;" value="Update Category &raquo;" />
		</p>
    	<?php $step = $ag->get_aggregator_step_by_orderDB($aggregator->id, 3); ?>
    	<p>
			<label>Add Feed URL Step 2:</label>
			<input type="hidden" name="order[]"	value="3" />
			<input type="text" name="url[]" value="<?php echo htmlspecialchars($step?$step['url']:''); ?>" />
			<label>FormID Type:</label>
			<select name="formIDType[]">
				<option value="name" <?php echo $step && $step['formIDType'] == 'name'?'selected':''?>>name</option>
				<option value="id" <?php echo $step && $step['formIDType'] == 'id'?'selected':''?>>id</option>
				<option value="index" <?php echo $step && $step['formIDType'] == 'index'?'selected':''?>>index</option>
			</select>
			<label>FormID Value:</label>
			<input type="text"	 name="formIDValue[]" value="<?php echo $step?$step['formIDValue']:''; ?>" />
		</p>
		<p>
			<label>Success Regular Expression:</label>
			<input type="text" name="successRegx[]" value="<?php echo htmlspecialchars($step?$step['successRegx']:''); ?>" />
			<input type="submit" name="buildParam" <?php echo $step['url']?'':'disabled="disabled"'; ?> onclick="document.detailForm.orderID.value=3;return true;" value="Build Parameters &raquo;" />
		</p>
		<input type="hidden" name="id" value="<?php echo $aggregator->id; ?>" />
		<p class="submit">
			<input type="submit" name="updateDetail" value="Update Aggregator &raquo;" />
	    </p>
	</form>
</div>
<?php
}

/**
 * Display All the aggregators in an table
 */
function wtg_display_aggregators_list() {
	global $wpdb;
	$table_name_aggregators = $wpdb->prefix . "_wtg_aggregators";
	
	# aggregrator sites using captcha
	$captcha_site_array = array("feedage.com","jordomedia.com","bloglines.com","rss-spider.com","feedlisting.com","blogville.us","blogged.com","rssnetworkfeedsdirectory.com","rssbuffet.com","bloglisting","Submitblognow","solarwarp.net","rssmountain.com","blogbunch.com","feedcat.net","rssmicro.com","millionrss.com");
	
	
	$cp = new WTG_Captcha();
	$cp->initDB();
	//$is_captcha_services_enabled = $cp->get_captcha_services_enabledDB();
	//print_r($is_captcha_services_enabled);
	$ag = new WTG_Aggregator();
	$ag->initDB();
	
	
	wtg_db_check_and_create();
	// java script function to handle the sub section of aggregator list.
	wtg_java_script();
	// call function to show latest version information and registeration information
	wtg_messages();
	
	
?>
	<div class="wrap">
	<h2>Manage Aggregators</h2>
	<div><a href="#" onclick="showalluser()"><b>Standard Aggregators</b></a> | <a href="#" onclick="showloginuser()"><b>Aggregators requiring username/password</b></a> | <a href="#" onclick="showcaptchauser()"><b>Aggregators requiring a Captcha</b></a></div>
	<script>
		function CheckAll(form){
			for(var i=0;i<form.elements.length;i++)
			{
				var e = form.elements[i];
				var agg_type = e.id;
				var selected = document.getElementById("selected_type").value;
				if ((e.name == 'aggregators[]') && (agg_type == selected)){
					//alert(e.name + " " + e.id + selected);
					e.checked = form.chkall.checked;
					document.getElementById( selected + "_checked").value = form.chkall.checked;
				}
				
			}
		}
	</script>
	<form id="aggregators" action="" method="post" name="aggregatorForm">
		<br />
		<input type="hidden" id="selected_type" value="standard" />
		&nbsp;&nbsp;&nbsp;<input name="chkall" type="checkbox" onclick="CheckAll(this.form);">&nbsp;&nbsp;Select All
		&nbsp;&nbsp;&nbsp;<input type="submit" name="enableChecked" value="Enable Checked" />
		&nbsp;&nbsp;&nbsp;<input type="submit" name="disableChecked" value="Disable Checked" />
		<br /><br />
		<div class="wrap" id="aggregators_requiring_all">
			<input type="hidden" id="standard_checked" value="false" />
			<h2>Standard Aggregators</h2>
			<table id="aggregators_list" class="widefat">
				<thead>
					<tr>
						<th> </th>
						<th>Site Name</th>
						<th>Has Category</th>
						<th>Status</th>
						<th>Enabled</th>
						<th colspan="3">Action</th>
					</tr>
				</thead>
				<tbody>
					<?php 
					$aggregators_list = $ag->get_all_aggregatorsDB();
				
					if (is_array($aggregators_list) && !empty($aggregators_list)) {
						//usort($aggregators_list, 'wtg_compare_by_name');
						
						$class = '';
						foreach ($aggregators_list as $aggregator) 
						{
							$class = ( $class == 'class="alternate"' ) ? '' : 'class="alternate"';
							//echo $aggregator->name." ".$aggregator->hasLogin." ".$aggregator->hasCaptcha." ".$aggregator->isReady."<br/>";
							$anchor = preg_replace('/\*$/', '', $aggregator->name);
							if($aggregator->hasLogin != 1)
							{
								if($aggregator->hasCaptcha != 1)
								{
									?>
										<tr <?php echo $class; ?>>
											<td><input type="checkbox" id="standard" name="aggregators[]" rel="standard" value="<?php echo $aggregator->id; ?>" /> </td>
											<td><a href="http://<?php echo $anchor;?>" target="_new"><?php echo htmlspecialchars($aggregator->name); if ($aggregator->hasLogin == 1) echo " *"; ?></a></td>
											<td><?php
													$catList = wtg_get_catlist($aggregator->name);
													if($catList) echo "has category";
													else {	echo "---";	}
												?>
											</td>
											<td><?php echo ($aggregator->isReady == 1)?'Ready':'Not Ready'; ?></td>
											<td><?php echo ($aggregator->enabled == 1)?'Enabled':'Disabled'; ?></td>
											<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=reverse&amp;dv=aggregators_requiring_all&amp;id=".$aggregator->id, 'manage_aggregators')?>"><?php echo ($aggregator->enabled == 1)?'Disable':'Enable'?></a></td>
											<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=edit&amp;id=".$aggregator->id, 'manage_aggregators')?>">Edit Detail</a></td>
											<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=delete&amp;dv=aggregators_requiring_all&amp;id=".$aggregator->id, 'manage_aggregators')?>" onclick="return confirm('Do you really want to delete this site?');">Delete</a></td>
										</tr>
									<?php
								}
								else{
									if($aggregator->enabled == 1){
										$enabled='Enabled';
										$enable= 'Disable';
									} else {
										$enabled='Disabled';
										$enable= 'Enable';
									}
									
									if($aggregator->isReady == 1)	$is_ready='Ready';
									else							$is_ready='Not Ready';

									$arr_captcha1[] = array("name" => $aggregator->name, "id" => $aggregator->id, "ready" => $is_ready, "enabled" => $enabled, "enable" => $enable);
								}
								
							}
							else if(!in_array($aggregator->name,$captcha_site_array))
							{
								if($aggregator->enabled == 1){
									$enabled='Enabled';
									$enable= 'Disable';
								} else {
									$enabled='Disabled';
									$enable= 'Enable';
								}
								
								if($aggregator->isReady == 1)	$is_ready='Ready';
								else							$is_ready='Not Ready';
								
								$arr_login[] = array("name" => $aggregator->name, "id" => $aggregator->id, "ready" => $is_ready, "enabled" => $enabled, "enable" => $enable);
							}
							else
							{
								if($aggregator->enabled == 1){
									$enabled='Enabled';
									$enable= 'Disable';
								} else {
									$enabled='Disabled';
									$enable= 'Enable';
								}
								
								if($aggregator->isReady == 1)	$is_ready='Ready';
								else							$is_ready='Not Ready';
								
								$arr_captcha2[] = array("name" => $aggregator->name, "id" => $aggregator->id, "ready" => $is_ready, "enabled" => $enabled, "enable" => $enable, "hasLogin" => $aggregator->hasLogin);
							}
						}
					} else {
						echo '<tr><td colspan="5" align="center"><strong>No entries found</strong></td></tr>';
					}
					?>
				</tbody>
			</table>
		</div>
		<div id="aggregators_requiring" style="display:none">
			<input type="hidden" id="with_login_checked" value="false" />
			<h2>Aggregators requiring username/password</h2>
			<table id="aggregators_list" class="widefat">
				<thead>
					<tr>
						<th> </th>
						<th>Site Name</th>
						<th>Has Category</th>
						<th>Status</th>
						<th>Enabled</th>
						<th colspan="3">Action</th>
					</tr>
				</thead>
				<tbody>
					<?php 
						usort($arr_login, 'wtg_compare_by_name');
						
						$class = '';
						foreach ($arr_login as $aggregator) {
						$anchor = preg_replace('/\*$/', '', $aggregator['name']);
						?>
						<tr <?php echo $class; ?>>
							<td><input type="checkbox" id="with_login" name="aggregators[]" rel="with_login" value="<?php echo $aggregator['id']; ?>" /> </td>
							<td><a href="http://<?php echo $anchor;?>" target="_new"><?php echo htmlspecialchars($aggregator['name']); echo " *";?></a></td>
							<td><?php
									$catList=wtg_get_catlist($aggregator['name']);
									if($catList)
									{
										echo "has category";
									} 
									else {	echo "---";	}
								?>
							</td>
							<td><?php echo $aggregator['ready']; ?></td>
							<td><?php echo $aggregator['enabled']; ?></td>
							<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=reverse&amp;dv=aggregators_requiring&amp;id=".$aggregator['id'], 'manage_aggregators')?>"><?php echo $aggregator['enable'];?></a></td>
							<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=edit&amp;id=".$aggregator['id'], 'manage_aggregators')?>">Edit Detail</a></td>
							<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=delete&amp;dv=aggregators_requiring&amp;id=".$aggregator['id'], 'manage_aggregators')?>" onclick="return confirm('Do you really want to delete this site?');">Delete</a></td>
						</tr>
					<?php
					}
					?>
				</tbody>
			</table>
		</div>
		
		<?php
	$arr_captcha=array_merge($arr_captcha1,$arr_captcha2);

	?>


	<div id="aggregators_requiring_captcha" style="display:none">
		<input type="hidden" id="with_captcha_checked" value="false" />
		<h2>Aggregators requiring a CAPTCHA</h2>
		<table id="aggregators_list" class="widefat">
			<thead>
				<tr>
					<th> </th>
					<th>Site Name</th>
					<th>Has Category</th>
					<th>Status</th>
					<th>Enabled</th>
					<th colspan="3">Action</th>
				</tr>
			</thead>
			<tbody>
				<?php 
					usort($arr_captcha, 'wtg_compare_by_name');
					
					$class = '';
					foreach ($arr_captcha as $aggregator) {
					$anchor = preg_replace('/\*$/', '', $aggregator['name']);
					?>
					<tr <?php echo $class; ?>>
						<td><input type="checkbox" id="with_captcha" name="aggregators[]" rel="with_captcha" value="<?php echo $aggregator['id']; ?>" /> </td>
						<td><a href="http://<?php echo $anchor;?>" target="_new"><?php echo htmlspecialchars($aggregator['name']); if ($aggregator['hasLogin'] == 1) echo " *";?></a></td>
						<td><?php
								$catList=wtg_get_catlist($aggregator['name']);
								if($catList)
								{
									echo "has category";
								} 
								else {	echo "---";	}
							?>
						</td>
						<td><?php echo $aggregator['ready']; ?></td>
						<td><?php echo $aggregator['enabled']; ?></td>
						<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=reverse&amp;dv=aggregators_requiring_captcha&amp;id=".$aggregator['id'], 'manage_aggregators')?>"><?php echo $aggregator['enable'];?></a></td>
						<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=edit&amp;id=".$aggregator['id'], 'manage_aggregators')?>">Edit Detail</a></td>
						<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_aggregators&amp;mode=delete&amp;dv=aggregators_requiring_captcha&amp;id=".$aggregator['id'], 'manage_aggregators')?>" onclick="return confirm('Do you really want to delete this site?');">Delete</a></td>
					</tr>
				<?php
				}
				?>
			</tbody>
		</table>
	</div>
	</form><br/>
	<b>Note:</b> Aggregators with a '*' beside their names require usernames/passwords.<br/><br/>
	</div>
			
	
	
		<?php
			
}

function wtg_get_catlist($aggregator) {
	if($aggregator == 'feednuts.com') {
		$catList=wtg_catlist_FeedNuts();
		return $catList;
	}
	if($aggregator == 'jordomedia.com') {
		$catList=wtg_catlist_Jordomedia();
		return $catList;
	}
	
	if($aggregator == 'medworm.com') {
		$catList=wtg_catlist_MedWorm();
		return $catList;
	}
	
	if($aggregator == 'moneyhighstreet.com') {
		$catList=wtg_catlist_MoneyHighStreet();
		return $catList;
	}
	
	if($aggregator == 'overskrift.dk') {
		$catList=wtg_catlist_overskrift();
		return $catList;
	}
	
	if($aggregator == 'plazoo.com') {
		$catList=wtg_catlist_plazoo();
		return $catList;
	}
	
	if($aggregator == 'rss-feeds-submission.com') {
		$catList=wtg_catlist_RssFeedsSubmission();
		return $catList;
	}
	
	if($aggregator == 'educational-feeds.com') {
		$catList=wtg_catlist_EducationalFeeds();
		return $catList;
	}
	
	if($aggregator == 'finance-investing.com') {
		$catList=wtg_catlist_FinanceInvesting();
		return $catList;
	}
	
	if($aggregator == 'government-central.com') {
		$catList=wtg_catlist_GovernmentFeeds();
		return $catList;
	}
	
	if($aggregator == 'medical-feeds.com') {
		$catList=wtg_catlist_MedicalFeeds();
		return $catList;
	}
	
	if($aggregator == 'newzalert.com') {
		$catList=wtg_catlist_NewzAlert();
		return $catList;
	}
	
	if($aggregator == 'political-humor.net') {
		$catList=wtg_catlist_PoliticalFeeds();
		return $catList;
	}
	
	if($aggregator == 'realty-feeds.net') {
		$catList=wtg_catlist_RealtyFeeds();
		return $catList;
	}
	
	if($aggregator == 'realtyfeedsearch.com') {
		$catList=wtg_catlist_RealtyFeedSearch();
		return $catList;
	}
	
	if($aggregator == 'religious-podcasts.net') {
		$catList=wtg_catlist_ReligiousPodcasts();
		return $catList;
	}
	
	if($aggregator == 'rss-network.com') {
		$catList=wtg_catlist_rssnetwork();
		return $catList;
	}
	
	if($aggregator == 'rss001.com') {
		$catList=wtg_catlist_RSS001();
		return $catList;
	}
	
	if($aggregator == 'rssmotron.com') {
		$catList=wtg_catlist_rssmotron();
		return $catList;
	}
	
	if($aggregator == 'rssnetworkfeedsdirectory.com') {
		$catList=wtg_catlist_rssnetworkfeedsdirectory();
		return $catList;
	}
	
	if($aggregator == 'rsstop10.com') {
		$catList=wtg_catlist_RSStop10();
		return $catList;
	}
	
	if($aggregator == 'solarwarp.net') {
		$catList=wtg_catlist_SolarWarpNet();
		return $catList;
	}
	
	if($aggregator == 'sports-feeds.com') {
		$catList=wtg_catlist_SportsFeeds();
		return $catList;
	}
	
	if($aggregator == 'videocasting-station.com') {
		$catList=wtg_catlist_VideocastingStation();
		return $catList;
	}
	
	if($aggregator == 'bloghub.com') {
		$catList=wtg_catlist_bloghub();
		return $catList;
	}
	
	if($aggregator == 'blogcatalog.com') {
		$catList=wtg_catlist_blogcatalog();
		return $catList;
	}
	
	if($aggregator == 'bloglisting') {
		$catList=wtg_catlist_bloglisting();
		return $catList;
	}
	
	if($aggregator == 'topblogging.com') {
		$catList=wtg_catlist_topblogging();
		return $catList;
	}
	
	if($aggregator == 'millionrss.com') {
		$catList=wtg_catlist_millionrss();
		return $catList;
	}
	
	if($aggregator == 'feedlisting.com') {
		$catList=wtg_catlist_feedlisting();
		return $catList;
	}
	
	if($aggregator == 'rssmountain.com') {
		$catList=wtg_catlist_rssmountain();
		return $catList;
	}
	
	if($aggregator == 'blogbunch.com') {
		$catList=wtg_catlist_blogbunch();
		return $catList;
	}
	
	if($aggregator == 'blogged.com') {
		$catList=wtg_catlist_blogged();
		return $catList;
	}
	
	if($aggregator == 'bloggernow.com') {
		$catList=wtg_catlist_bloggernow();
		return $catList;
	}
	
	if($aggregator == 'rssmicro.com') {
		$catList=wtg_catlist_rssmicro();
		return $catList;
	}
	
	if($aggregator == 'topblogarea.com') {
		$catList=wtg_catlist_topblogarea();
		return $catList;
	}
	return false;
}

//wtg_messages();

function wtg_java_script() {
?>
	<script language="javascript">
	function showloginuser()
	{
		var dv="aggregators_requiring";
		document.getElementById(dv).style.display="block"
		document.getElementById(dv).style.display="visible"
		document.getElementById("aggregators_requiring_all").style.display = "none";
		document.getElementById("aggregators_requiring_captcha").style.display = "none";
		document.getElementById("selected_type").value = "with_login";
		document.aggregatorForm.chkall = document.getElementById("with_login_checked").value ;
		if (document.getElementById("with_login_checked").value == 'true')
			document.aggregatorForm.chkall.checked = true;
		else
			document.aggregatorForm.chkall.checked = false;
	}
	function showcaptchauser()
	{
		var dv="aggregators_requiring_captcha";
		document.getElementById(dv).style.display="block"
		document.getElementById(dv).style.display="visible"
		document.getElementById("aggregators_requiring_all").style.display = "none";
		document.getElementById("aggregators_requiring").style.display = "none";
		document.getElementById("selected_type").value = "with_captcha";
		document.aggregatorForm.chkall = document.getElementById("with_captcha_checked").value ;
		if (document.getElementById("with_captcha_checked").value == 'true')
			document.aggregatorForm.chkall.checked = true;
		else
			document.aggregatorForm.chkall.checked = false;
	}
	function showalluser()
	{
		var dv="aggregators_requiring_all";
		document.getElementById(dv).style.display="block"
		document.getElementById(dv).style.display="visible"
		document.getElementById("aggregators_requiring").style.display = "none";
		document.getElementById("aggregators_requiring_captcha").style.display = "none";
		document.getElementById("selected_type").value = "standard";
		document.aggregatorForm.chkall = document.getElementById("standard_checked").value ;
		if (document.getElementById("standard_checked").value == 'true')
			document.aggregatorForm.chkall.checked = true;
		else
			document.aggregatorForm.chkall.checked = false;
	}
	</script>
<?php
}
?>