<?php

$timestamp = wp_next_scheduled( 'my_hourly_event' );
$next = $timestamp-time();
$date = date( "Y-m-d H:i:s", $timestamp );

$this->getOptions();

//$this->spinSchedule();

?>

<style type="text/css"> @import url("<?php echo WP_PLUGIN_URL; ?>/wpspin/css/table.css"); </style>
<script src="<?php echo WP_PLUGIN_URL; ?>/wpspin/js/jquery.clock.js"></script>

<script type="text/javascript">
jQuery(function($) {
   var options = {
        timeNotation: '12h',
        am_pm: true,
        fontFamily: 'Verdana, Times New Roman',
        fontSize: '20px',
        foreground: 'gray',
      }; 
   jQuery('.jclock').jclock(options);
});

var elapsed_seconds = <?php echo $next; ?>;

function get_elapsed_time_string(total_seconds) {
    if( total_seconds < 0 ) {
		document.write('Schedule mode is working now. Please <a href="'+location.href+'">refresh page</a> after few minutes.');
		return false;
	}
	function pretty_time_string(num) {
        return ( num < 10 ? "0" : "" ) + num;
    }
    var hours = Math.floor(total_seconds / 3600);
    total_seconds = total_seconds % 3600;

    var minutes = Math.floor(total_seconds / 60);
    total_seconds = total_seconds % 60;

    var seconds = Math.floor(total_seconds);

    // Pad the minutes and seconds with leading zeros, if required
    hours = pretty_time_string(hours);
    minutes = pretty_time_string(minutes);
    seconds = pretty_time_string(seconds);

    // Compose the string for display
    var currentTimeString = hours + ":" + minutes + ":" + seconds;
	
    return currentTimeString;
}

setInterval(function() {
    if( elapsed_seconds > 0 ) elapsed_seconds = elapsed_seconds - 1;
    else{
		//setTimeout("location.reload(true)",10000);
		elapsed_seconds = -1;
		return false;
	}
    jQuery('#countdown').text(get_elapsed_time_string(elapsed_seconds));
}, 1000);

function changeStatus($id) {
    jQuery('#st'+$id).html('<font color="black">changing ...</font>');
    jQuery.ajax({  
        type: "POST",  
        url: "<?php echo WP_PLUGIN_URL; ?>/wpspin/ajax.php", 
        data: "status="+$id,
        success: function(get) {
            jQuery('#st'+$id).html(get);
        }
    });
}
</script>

<br><br>
<center>
<div class="jclock"></div>
<br>
<!--<br>Next schedule start: <br><br><div id="countdown" style="font-family: Verdana, 'Times New Roman'; font-size: 20px; color: gray; "></div><br>-->
</center><br>
<b>Auto Schedule Updates: 
<?php 
if( $this->option['wpspin_autospin'] == 1 AND $this->option['wpspin_auto_options'] == 3 ) {
    echo "<font color='green'>ON</font><br><br>";?>
<input type="text" name="wpspin_time_count" disabled size="2" value="<?php echo $this->option['wpspin_time_count'];?>"><select disabled name="wpspin_time_type" style="width: 150px"><option value="1" <?php if($this->option['wpspin_time_type']=='1')echo "selected";?>><?php _e('Hours') ?></option><option value="2" <?php if($this->option['wpspin_time_type']=='2')echo "selected";?>><?php _e('Days') ?></option><option value="3" <?php if($this->option['wpspin_time_type']=='3')echo "selected";?>><?php _e('Weeks') ?></option><option value="4" <?php if($this->option['wpspin_time_type']=='4')echo "selected";?>><?php _e('Months') ?></option></select><br><br>
<select disabled name="wpspin_spin_count">
<?php for($i=1;$i<11;$i++) {
    if( $this->option['wpspin_spin_count'] == $i ) echo "<option value='$i' selected>$i</option>";
    else echo "<option value='$i'>$i</option>";
}
?></select> <?php _e('Number of Post Updates to Schedule') ?><br>
<table align='left' style='width:200px'><tr><td><?php if( $this->option['wpspin_publish']==1 ) echo '<input disabled name="wpspin_publish" type="radio" value="1" checked> Auto publish'; else echo '<input disabled name="wpspin_publish" type="radio" value="2" checked> Publish as Draft'; ?></td></tr></table><br>
<?php
}
else echo "<font color='red'>OFF</font>"; 
echo "<br><br></b>";

$this->wpDB();

if( $rows = $this->wpdb->get_results("SELECT * FROM `".$this->table."` WHERE `auto_options`='3' AND `spin_count`<>'0'", ARRAY_A) ) {
    echo "Found <font color='green'>".count($rows)." posts</font> for schedule (individual mode)<br><br>"; ?>
    <table border='1'>
    <thead>
    <tr class="odd">
        <th scope="col">Date</th>
        <th scope="col">Mode</th>
        <th scope="col">Post Title</th>	
        <th scope="col">Number of Post Updates</th>	
        <th scope="col">Quality</th>
        <th scope="col">Publish/Draft</th> 
        <th scope="col">Status</th>         
    </tr>	
    </thead><tbody>
<?php
    
    foreach( $rows as $post ) {
        $dates = explode( ",", $post['alarm'] );
        if( $post['quality'] == 1 ) $quality = 'Good';
        else if( $post['quality'] == 2 ) $quality = 'Better';
        else $quality = 'Best';
        if( $post['spin_publish'] == 1 ) $publish = 'Publish';
        else $publish = 'Draft';
        switch( $post['mode'] ) {
            case 'identify':
                $mode = 'Identify Synonyms';
                break;
            case 'replace':
                $mode = 'Auto Spin';
                break;
            case 'manual':
                $mode = 'Manual Synonyms';
                break;
        }
        if( $post['status'] == 1 ) $status = "<font color='green'>enabled</font>";
        else $status = "<font color='red'>disabled</font>";
        $postInfo = $this->wpdb->get_row("SELECT `guid`,`post_title` FROM `".$this->table_posts."` WHERE ID = '".$post['id']."' AND post_status = 'publish' LIMIT 1",ARRAY_A);
        $urlPost = $postInfo['guid'];
        $titlePost = $postInfo['post_title'];
        $show = 1;
        $count = count($dates);
        foreach( $dates as $d ) {
            if( $show ) {
                echo "<tr><td>$d</td><td rowspan='$count'>".$mode."</td><td rowspan='$count'><a href='$urlPost'>".$titlePost."</a></td><td rowspan='$count'>".$count."</td><td rowspan='$count'>".$quality."</td><td rowspan='$count'>".$publish."</td><td rowspan='$count'><a href='#' onclick='changeStatus(".$post['id'].");'><div id='st".$post['id']."'>$status</div></a></td></tr>";
                $show = 0;
            }
            else echo "<tr><td>$d</td></tr>";
        }
    }
    
    echo "</tbody></table>";
} else {
    echo "<font color='red'>Not found</font> posts for schedule (individual mode)";
}
?>
<br>