﻿(function() 
{
    tinymce.PluginManager.requireLangPack('wpspin');

    tinymce.create('tinymce.plugins.WpspinPlugin', 
        {
            init : function(ed, url) 
            {
                ed.addCommand('mceWpspinR', 
                    function() 
                    {
                        jQuery("#rWindow").trigger('click');
                    }
                );
                ed.addCommand('mceWpspinI', 
                    function() 
                    {
                        jQuery("#iWindow").trigger('click');
                    }
                );
                
                ed.addButton('wpspin1', 
                    {
                        title : 'WPSpin - Auto Spin',
                        cmd : 'mceWpspinR',
                        image : url + '/../images/a.ico'
                    }
                );		
                ed.addButton('wpspin2', 
                    {
                        title : 'WPSpin - Identify Synonyms',
                        cmd : 'mceWpspinI',
                        image : url + '/../images/s.ico'
                    }
                );

                ed.onNodeChange.add(function(ed, cm, n) {
                    var content1 = tinyMCE.activeEditor.selection.getContent({format : 'raw'});
                    var content2 = tinyMCE.activeEditor.getContent({format : 'raw'});
                    if(content1=='' || content1=='<p><br mce_bogus="1"></p>') cm.setDisabled('wpspin2',true);
                    else cm.setDisabled('wpspin2',false);
                    if(content2=='' || content2=='<p><br mce_bogus="1"></p>') {
                        cm.setDisabled('wpspin1',true);
                    } else {
                        cm.setDisabled('wpspin1',false);
                    }
                });
            },
        
            createControl : function(n, cm) 
            {
                return null;
            },

            getInfo : function() 
            {
                return {
                    longname : 'WPSpin',
                    author : 'Alex',
                    authorurl : 'http://localhost/wp',
                    infourl : 'http://localhost/wp',
                    version : "0.7"
                };
            }
        });

    // Register plugin
    tinymce.PluginManager.add('wpspin', tinymce.plugins.WpspinPlugin);
})();
