<?php

 
$themename = "ESP Theme";
$shortname = "ngesp";

$template_path = get_bloginfo('template_directory');
$alt_stylesheet_path = TEMPLATEPATH . '/skins/';
$alt_stylesheets = array();


if ( is_dir($alt_stylesheet_path) ) {
	if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) { 
		while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
			if(stristr($alt_stylesheet_file, ".css") !== false) {
				$alt_stylesheets[] = $alt_stylesheet_file;
			}
		}	
	}
}


$options = array (
 
 array( "name" => "Theme skin",
						"desc" => "Choose a skin for your site",
					    "id" => $shortname."_alt_stylesheet",
					    "std" => "Please select a skin:",
					    "type" => "select",
					    "options" => $alt_stylesheets),
 
	
 
array( "name" => "Your Tagline",
        			  "desc" => "Enter a tagline here.",
       				  "id" => $shortname."_header_tagline",
        			  "std" => "Enter Your Tagline",
                      "type" => "text"),
					  
array( "name" => "Logo",
						"desc" => "Paste the full URL to your logo here.",
						"id" => $shortname."_logo_url",
						"std" => $template_path . "/images/logobox.gif",
						"type" => "text"),	
						
											
array( "name" => "Choose Blog Title rather than Logo",
						"desc" => "I would like text title rather than logo.",
						"id" => $shortname."_show_blog_title",
						"std" => "false",
						"type" => "checkbox"),	
	
 
  array("name" => "Favicon",
						"desc" => "Enter the url for your favicon if you wish to show it.",
						"id" => $shortname."_favicon",
						"std" => $template_path . "/images/favicon.ico",
						"type" => "text"),		

				
						
 
array( "type" => "close")
 
);

	

function mytheme_wp_head() { 
	$stylesheet = get_option('ngesp_alt_stylesheet');
	if($stylesheet != ''){?>
		<link href="<?php bloginfo('template_directory'); ?>/skins/<?php echo $stylesheet; ?>" rel="stylesheet" type="text/css" />
<?php }
} 

add_action('wp_head', 'mytheme_wp_head');


function mytheme_add_admin() {
 
global $themename, $shortname, $options;
 
if ( $_GET['page'] == basename(__FILE__) ) {
 
if ( 'save' == $_REQUEST['action'] ) {
 
foreach ($options as $value) {
update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }
 
foreach ($options as $value) {
if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
 
header("Location: themes.php?page=functions.php&saved=true");
die;
 
} else if( 'reset' == $_REQUEST['action'] ) {
 
foreach ($options as $value) {
delete_option( $value['id'] ); }
 
header("Location: themes.php?page=functions.php&reset=true");
die;
 
}
}
 
add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
 
}
 
function mytheme_admin() {
 
global $themename, $shortname, $options;
 
if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
 
?>



<div class="wrap">

<h2><?php echo $themename; ?> Settings</h2>


 
<form method="post">


 
<?php foreach ($options as $value) {
switch ( $value['type'] ) {
 
case "open":
?>

<table width="100%" border="0" style="background-color:#eef5fb; padding:10px;">


 
<?php break;
 
case "close":
?>
 
</table>
 
<?php break;
 
case "title":
?>
<div style="background:#eaeaea; padding:10px; margin-bottom:10px;">
<h3 style="font-family:Georgia,'Times New Roman',Times,serif;"><?php echo $value['name']; ?></h3></div>



 
<?php break;
 
case 'text':
?>
 
<div >
<div style="background:#eaeaea; padding:10px; margin-bottom:10px; width:400px; font-color:#222;
font-size:12px; border-bottom:1px dotted #ededed;"><strong><?php echo $value['name']; ?></strong></div>
<div><input style="width:400px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" /></div>
</div>
 
<div>
<div style="margin-top:10px; margin-bottom:10px; border-bottom:1px dotted #ddd; width:420px; padding-bottom:10px;"><small><?php echo $value['desc']; ?></small></div>
</div>
 
<?php
break;
 
case 'textarea':
?>
 
<div >
<div><strong><?php echo $value['name']; ?></strong></div>
<div style="background:#eaeaea; padding:10px; margin-bottom:10px; width:400px; font-color:#222;
font-size:12px; border-bottom:1px dotted #ededed;"><textarea name="<?php echo $value['id']; ?>" style="width:400px; height:200px;" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?></textarea></div>
 
</div>
 
<div>
<div style="margin-top:10px; margin-bottom:10px; border-bottom:1px dotted #ddd; width:420px; padding-bottom:10px;"><small><?php echo $value['desc']; ?></small></div>
</div>

<?php
break;
 
case 'select':
?>
<div>
<div style="background:#eaeaea; padding:10px; margin-bottom:10px; width:400px; font-color:#222;
font-size:12px; border-bottom:1px dotted #ededed;"><strong><?php echo $value['name']; ?></strong></div>
<div><select style="width:240px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"><?php foreach ($value['options'] as $option) { ?><option<?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?></select></div>
</div>
</div>
 
<div>
<div style="margin-top:10px; margin-bottom:10px; border-bottom:1px dotted #ddd; width:420px; padding-bottom:10px;"><small><?php echo $value['desc']; ?></small></div>
</div>
 
<?php
break;
 
case "checkbox":
?>
<div>
<div style="background:#eaeaea; padding:10px; margin-bottom:10px; width:400px; font-color:#222;
font-size:12px; border-bottom:1px dotted #ededed;"><strong><?php echo $value['name']; ?></strong></div>
<div><?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
<input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
</div>
</div>
 
<div>
<div style="margin-top:10px; margin-bottom:10px; border-bottom:1px dotted #ddd; width:420px; padding-bottom:10px;"><small><?php echo $value['desc']; ?></small></div>
</div>
 
<?php break;
 
}
}
?>




 
<p class="submit">
<input name="save" type="submit" value="Save changes" />
<input type="hidden" name="action" value="save" />
</p>
</form>




<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>


 
<?php
}




add_action('admin_menu', 'mytheme_add_admin');





// Register Widgets to Sidebar

if ( function_exists('register_sidebars') )
    register_sidebars(2, array(
    'before_widget' => '<li id="%1$s" class="widget %2$s content-box">',
    'after_widget' => '</li>',
    'before_title' => '<h3>',
    'after_title' => '</h3>',
    ));

function get_rightbar(){
include (TEMPLATEPATH . "/sidebar_testimonials.php");
}
?>