<?php
/*
Plugin Name: Duplicate Posts Eraser
Plugin URI: http://www.theblackmelvyn.com/
Description: Deletes duplicate posts
Author: BlackMelvyn
Version: 0.1
Author URI: http://www.theblackmelvyn.com
*/

function clearDuplicatePosts(){	
	global $wpdb;
	$wpdb->query("
	delete bad_rows.*
	from $wpdb->posts as bad_rows
	inner join (
	select post_title, MIN(id) as min_id
	from $wpdb->posts
	group by post_title
	having count(*) > 1
	) as good_rows on good_rows.post_title = bad_rows.post_title
	and good_rows.min_id <> bad_rows.id;
	");
}

add_action('publish_post', 'clearDuplicatePosts');
?>